/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.number;

import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.FormattedStringBuilder;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.text.NumberFormat;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.text.UnicodeSet;

public class AffixUtils {
    private static final int STATE_BASE = 0;
    private static final int STATE_FIRST_QUOTE = 1;
    private static final int STATE_INSIDE_QUOTE = 2;
    private static final int STATE_AFTER_QUOTE = 3;
    private static final int STATE_FIRST_CURR = 4;
    private static final int STATE_SECOND_CURR = 5;
    private static final int STATE_THIRD_CURR = 6;
    private static final int STATE_FOURTH_CURR = 7;
    private static final int STATE_FIFTH_CURR = 8;
    private static final int STATE_OVERFLOW_CURR = 9;
    private static final int TYPE_CODEPOINT = 0;
    public static final int TYPE_MINUS_SIGN = -1;
    public static final int TYPE_PLUS_SIGN = -2;
    public static final int TYPE_APPROXIMATELY_SIGN = -3;
    public static final int TYPE_PERCENT = -4;
    public static final int TYPE_PERMILLE = -5;
    public static final int TYPE_CURRENCY_SINGLE = -6;
    public static final int TYPE_CURRENCY_DOUBLE = -7;
    public static final int TYPE_CURRENCY_TRIPLE = -8;
    public static final int TYPE_CURRENCY_QUAD = -9;
    public static final int TYPE_CURRENCY_QUINT = -10;
    public static final int TYPE_CURRENCY_OVERFLOW = -15;

    public static int estimateLength(CharSequence patternString) {
        int cp;
        if (patternString == null) {
            return 0;
        }
        int state2 = 0;
        int length = 0;
        block9: for (int offset = 0; offset < patternString.length(); offset += Character.charCount(cp)) {
            cp = Character.codePointAt(patternString, offset);
            switch (state2) {
                case 0: {
                    if (cp == 39) {
                        state2 = 1;
                        continue block9;
                    }
                    ++length;
                    continue block9;
                }
                case 1: {
                    if (cp == 39) {
                        ++length;
                        state2 = 0;
                        continue block9;
                    }
                    ++length;
                    state2 = 2;
                    continue block9;
                }
                case 2: {
                    if (cp == 39) {
                        state2 = 3;
                        continue block9;
                    }
                    ++length;
                    continue block9;
                }
                case 3: {
                    if (cp == 39) {
                        ++length;
                        state2 = 2;
                        continue block9;
                    }
                    ++length;
                    continue block9;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        switch (state2) {
            case 1: 
            case 2: {
                throw new IllegalArgumentException("Unterminated quote: \"" + patternString + "\"");
            }
        }
        return length;
    }

    public static int escape(CharSequence input2, StringBuilder output) {
        int cp;
        if (input2 == null) {
            return 0;
        }
        int state2 = 0;
        int startLength = output.length();
        block4: for (int offset = 0; offset < input2.length(); offset += Character.charCount(cp)) {
            cp = Character.codePointAt(input2, offset);
            switch (cp) {
                case 39: {
                    output.append("''");
                    continue block4;
                }
                case 37: 
                case 43: 
                case 45: 
                case 164: 
                case 8240: {
                    if (state2 == 0) {
                        output.append('\'');
                        output.appendCodePoint(cp);
                        state2 = 2;
                        continue block4;
                    }
                    output.appendCodePoint(cp);
                    continue block4;
                }
                default: {
                    if (state2 == 2) {
                        output.append('\'');
                        output.appendCodePoint(cp);
                        state2 = 0;
                        continue block4;
                    }
                    output.appendCodePoint(cp);
                }
            }
        }
        if (state2 == 2) {
            output.append('\'');
        }
        return output.length() - startLength;
    }

    public static String escape(CharSequence input2) {
        if (input2 == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        AffixUtils.escape(input2, sb);
        return sb.toString();
    }

    public static final NumberFormat.Field getFieldForType(int type) {
        switch (type) {
            case -1: {
                return NumberFormat.Field.SIGN;
            }
            case -2: {
                return NumberFormat.Field.SIGN;
            }
            case -3: {
                return NumberFormat.Field.APPROXIMATELY_SIGN;
            }
            case -4: {
                return NumberFormat.Field.PERCENT;
            }
            case -5: {
                return NumberFormat.Field.PERMILLE;
            }
            case -6: {
                return NumberFormat.Field.CURRENCY;
            }
            case -7: {
                return NumberFormat.Field.CURRENCY;
            }
            case -8: {
                return NumberFormat.Field.CURRENCY;
            }
            case -9: {
                return NumberFormat.Field.CURRENCY;
            }
            case -10: {
                return NumberFormat.Field.CURRENCY;
            }
            case -15: {
                return NumberFormat.Field.CURRENCY;
            }
        }
        throw new AssertionError();
    }

    public static int unescape(CharSequence affixPattern, FormattedStringBuilder output, int position2, SymbolProvider provider, NumberFormat.Field field2) {
        assert (affixPattern != null);
        int length = 0;
        long tag2 = 0L;
        while (AffixUtils.hasNext(tag2, affixPattern)) {
            int typeOrCp = AffixUtils.getTypeOrCp(tag2 = AffixUtils.nextToken(tag2, affixPattern));
            if (typeOrCp == -15) {
                length += output.insertCodePoint(position2 + length, 65533, NumberFormat.Field.CURRENCY);
                continue;
            }
            if (typeOrCp < 0) {
                length += output.insert(position2 + length, provider.getSymbol(typeOrCp), AffixUtils.getFieldForType(typeOrCp));
                continue;
            }
            length += output.insertCodePoint(position2 + length, typeOrCp, field2);
        }
        return length;
    }

    public static int unescapedCount(CharSequence affixPattern, boolean lengthOrCount, SymbolProvider provider) {
        int length = 0;
        long tag2 = 0L;
        while (AffixUtils.hasNext(tag2, affixPattern)) {
            int typeOrCp = AffixUtils.getTypeOrCp(tag2 = AffixUtils.nextToken(tag2, affixPattern));
            if (typeOrCp == -15) {
                ++length;
                continue;
            }
            if (typeOrCp < 0) {
                CharSequence symbol = provider.getSymbol(typeOrCp);
                length += lengthOrCount ? symbol.length() : Character.codePointCount(symbol, 0, symbol.length());
                continue;
            }
            length += lengthOrCount ? Character.charCount(typeOrCp) : 1;
        }
        return length;
    }

    public static boolean containsType(CharSequence affixPattern, int type) {
        if (affixPattern == null || affixPattern.length() == 0) {
            return false;
        }
        long tag2 = 0L;
        while (AffixUtils.hasNext(tag2, affixPattern)) {
            if (AffixUtils.getTypeOrCp(tag2 = AffixUtils.nextToken(tag2, affixPattern)) != type) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCurrencySymbols(CharSequence affixPattern) {
        if (affixPattern == null || affixPattern.length() == 0) {
            return false;
        }
        long tag2 = 0L;
        while (AffixUtils.hasNext(tag2, affixPattern)) {
            int typeOrCp = AffixUtils.getTypeOrCp(tag2 = AffixUtils.nextToken(tag2, affixPattern));
            if (typeOrCp >= 0 || AffixUtils.getFieldForType(typeOrCp) != NumberFormat.Field.CURRENCY) continue;
            return true;
        }
        return false;
    }

    public static String replaceType(CharSequence affixPattern, int type, char replacementChar) {
        if (affixPattern == null || affixPattern.length() == 0) {
            return "";
        }
        char[] chars = affixPattern.toString().toCharArray();
        long tag2 = 0L;
        while (AffixUtils.hasNext(tag2, affixPattern)) {
            if (AffixUtils.getTypeOrCp(tag2 = AffixUtils.nextToken(tag2, affixPattern)) != type) continue;
            int offset = AffixUtils.getOffset(tag2);
            chars[offset - 1] = replacementChar;
        }
        return new String(chars);
    }

    public static boolean containsOnlySymbolsAndIgnorables(CharSequence affixPattern, UnicodeSet ignorables) {
        if (affixPattern == null) {
            return true;
        }
        long tag2 = 0L;
        while (AffixUtils.hasNext(tag2, affixPattern)) {
            int typeOrCp = AffixUtils.getTypeOrCp(tag2 = AffixUtils.nextToken(tag2, affixPattern));
            if (typeOrCp < 0 || ignorables.contains(typeOrCp)) continue;
            return false;
        }
        return true;
    }

    public static void iterateWithConsumer(CharSequence affixPattern, TokenConsumer consumer) {
        assert (affixPattern != null);
        long tag2 = 0L;
        while (AffixUtils.hasNext(tag2, affixPattern)) {
            tag2 = AffixUtils.nextToken(tag2, affixPattern);
            int typeOrCp = AffixUtils.getTypeOrCp(tag2);
            consumer.consumeToken(typeOrCp);
        }
    }

    private static long nextToken(long tag2, CharSequence patternString) {
        int offset = AffixUtils.getOffset(tag2);
        int state2 = AffixUtils.getState(tag2);
        block32: while (offset < patternString.length()) {
            int cp = Character.codePointAt(patternString, offset);
            int count2 = Character.charCount(cp);
            switch (state2) {
                case 0: {
                    switch (cp) {
                        case 39: {
                            state2 = 1;
                            offset += count2;
                            continue block32;
                        }
                        case 45: {
                            return AffixUtils.makeTag(offset + count2, -1, 0, 0);
                        }
                        case 43: {
                            return AffixUtils.makeTag(offset + count2, -2, 0, 0);
                        }
                        case 126: {
                            return AffixUtils.makeTag(offset + count2, -3, 0, 0);
                        }
                        case 37: {
                            return AffixUtils.makeTag(offset + count2, -4, 0, 0);
                        }
                        case 8240: {
                            return AffixUtils.makeTag(offset + count2, -5, 0, 0);
                        }
                        case 164: {
                            state2 = 4;
                            offset += count2;
                            continue block32;
                        }
                    }
                    return AffixUtils.makeTag(offset + count2, 0, 0, cp);
                }
                case 1: {
                    if (cp == 39) {
                        return AffixUtils.makeTag(offset + count2, 0, 0, cp);
                    }
                    return AffixUtils.makeTag(offset + count2, 0, 2, cp);
                }
                case 2: {
                    if (cp == 39) {
                        state2 = 3;
                        offset += count2;
                        continue block32;
                    }
                    return AffixUtils.makeTag(offset + count2, 0, 2, cp);
                }
                case 3: {
                    if (cp == 39) {
                        return AffixUtils.makeTag(offset + count2, 0, 2, cp);
                    }
                    state2 = 0;
                    continue block32;
                }
                case 4: {
                    if (cp == 164) {
                        state2 = 5;
                        offset += count2;
                        continue block32;
                    }
                    return AffixUtils.makeTag(offset, -6, 0, 0);
                }
                case 5: {
                    if (cp == 164) {
                        state2 = 6;
                        offset += count2;
                        continue block32;
                    }
                    return AffixUtils.makeTag(offset, -7, 0, 0);
                }
                case 6: {
                    if (cp == 164) {
                        state2 = 7;
                        offset += count2;
                        continue block32;
                    }
                    return AffixUtils.makeTag(offset, -8, 0, 0);
                }
                case 7: {
                    if (cp == 164) {
                        state2 = 8;
                        offset += count2;
                        continue block32;
                    }
                    return AffixUtils.makeTag(offset, -9, 0, 0);
                }
                case 8: {
                    if (cp == 164) {
                        state2 = 9;
                        offset += count2;
                        continue block32;
                    }
                    return AffixUtils.makeTag(offset, -10, 0, 0);
                }
                case 9: {
                    if (cp == 164) {
                        offset += count2;
                        continue block32;
                    }
                    return AffixUtils.makeTag(offset, -15, 0, 0);
                }
            }
            throw new AssertionError();
        }
        switch (state2) {
            case 0: {
                return -1L;
            }
            case 1: 
            case 2: {
                throw new IllegalArgumentException("Unterminated quote in pattern affix: \"" + patternString + "\"");
            }
            case 3: {
                return -1L;
            }
            case 4: {
                return AffixUtils.makeTag(offset, -6, 0, 0);
            }
            case 5: {
                return AffixUtils.makeTag(offset, -7, 0, 0);
            }
            case 6: {
                return AffixUtils.makeTag(offset, -8, 0, 0);
            }
            case 7: {
                return AffixUtils.makeTag(offset, -9, 0, 0);
            }
            case 8: {
                return AffixUtils.makeTag(offset, -10, 0, 0);
            }
            case 9: {
                return AffixUtils.makeTag(offset, -15, 0, 0);
            }
        }
        throw new AssertionError();
    }

    private static boolean hasNext(long tag2, CharSequence string) {
        assert (tag2 >= 0L);
        int state2 = AffixUtils.getState(tag2);
        int offset = AffixUtils.getOffset(tag2);
        if (state2 == 2 && offset == string.length() - 1 && string.charAt(offset) == '\'') {
            return false;
        }
        if (state2 != 0) {
            return true;
        }
        return offset < string.length();
    }

    private static int getTypeOrCp(long tag2) {
        assert (tag2 >= 0L);
        int type = AffixUtils.getType(tag2);
        return type == 0 ? AffixUtils.getCodePoint(tag2) : -type;
    }

    private static long makeTag(int offset, int type, int state2, int cp) {
        long tag2 = 0L;
        tag2 |= (long)offset;
        tag2 |= -((long)type) << 32;
        tag2 |= (long)state2 << 36;
        assert ((tag2 |= (long)cp << 40) >= 0L);
        return tag2;
    }

    private static int getOffset(long tag2) {
        return (int)(tag2 & 0xFFFFFFFFFFFFFFFFL);
    }

    private static int getType(long tag2) {
        return (int)(tag2 >>> 32 & 0xFL);
    }

    private static int getState(long tag2) {
        return (int)(tag2 >>> 36 & 0xFL);
    }

    private static int getCodePoint(long tag2) {
        return (int)(tag2 >>> 40);
    }

    public static interface TokenConsumer {
        public void consumeToken(int var1);
    }

    public static interface SymbolProvider {
        public CharSequence getSymbol(int var1);
    }
}

