/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.number;

import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.number.DecimalQuantity;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.number.LongNameHandler;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.number.MicroProps;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.number.MicroPropsGenerator;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.number.MixedUnitLongNameHandler;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.number.NumberFormatter;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.text.PluralRules;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.util.MeasureUnit;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.List;

public class LongNameMultiplexer
implements MicroPropsGenerator {
    private final MicroPropsGenerator fParent;
    private List<ParentlessMicroPropsGenerator> fHandlers;
    private List<MeasureUnit> fMeasureUnits;

    public LongNameMultiplexer(MicroPropsGenerator fParent) {
        this.fParent = fParent;
    }

    public static LongNameMultiplexer forMeasureUnits(ULocale locale, List<MeasureUnit> units, NumberFormatter.UnitWidth width, String unitDisplayCase, PluralRules rules, MicroPropsGenerator parent) {
        LongNameMultiplexer result2 = new LongNameMultiplexer(parent);
        assert (units.size() > 0);
        result2.fMeasureUnits = new ArrayList<MeasureUnit>();
        result2.fHandlers = new ArrayList<ParentlessMicroPropsGenerator>();
        for (int i = 0; i < units.size(); ++i) {
            MeasureUnit unit = units.get(i);
            result2.fMeasureUnits.add(unit);
            if (unit.getComplexity() == MeasureUnit.Complexity.MIXED) {
                MixedUnitLongNameHandler mlnh = MixedUnitLongNameHandler.forMeasureUnit(locale, unit, width, unitDisplayCase, rules, null);
                result2.fHandlers.add(mlnh);
                continue;
            }
            LongNameHandler lnh = LongNameHandler.forMeasureUnit(locale, unit, width, unitDisplayCase, rules, null);
            result2.fHandlers.add(lnh);
        }
        return result2;
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity quantity) {
        MicroProps micros = this.fParent.processQuantity(quantity);
        for (int i = 0; i < this.fHandlers.size(); ++i) {
            if (!this.fMeasureUnits.get(i).equals(micros.outputUnit)) continue;
            ParentlessMicroPropsGenerator handler = this.fHandlers.get(i);
            return handler.processQuantityWithMicros(quantity, micros);
        }
        throw new AssertionError((Object)" We shouldn't receive any outputUnit for which we haven't already got a LongNameHandler");
    }

    public static interface ParentlessMicroPropsGenerator {
        public MicroProps processQuantityWithMicros(DecimalQuantity var1, MicroProps var2);
    }
}

