/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.number;

import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.number.DecimalQuantity;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.number.MicroProps;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.number.MicroPropsGenerator;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.number.UsagePrefsHandler;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.units.ComplexUnitsConverter;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.units.ConversionRates;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.units.MeasureUnitImpl;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.util.MeasureUnit;

public class UnitConversionHandler
implements MicroPropsGenerator {
    private final MicroPropsGenerator fParent;
    private MeasureUnit fOutputUnit;
    private ComplexUnitsConverter fComplexUnitConverter;

    public UnitConversionHandler(MeasureUnit targetUnit, MicroPropsGenerator parent) {
        this.fOutputUnit = targetUnit;
        this.fParent = parent;
        MeasureUnitImpl targetUnitImpl = MeasureUnitImpl.forIdentifier(targetUnit.getIdentifier());
        this.fComplexUnitConverter = new ComplexUnitsConverter(targetUnitImpl, new ConversionRates());
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity quantity) {
        MicroProps result2 = this.fParent.processQuantity(quantity);
        quantity.roundToInfinity();
        ComplexUnitsConverter.ComplexConverterResult complexConverterResult = this.fComplexUnitConverter.convert(quantity.toBigDecimal(), result2.rounder);
        result2.outputUnit = this.fOutputUnit;
        UsagePrefsHandler.mixedMeasuresToMicros(complexConverterResult, quantity, result2);
        return result2;
    }
}

