/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.number.parse;

import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.StringSegment;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.number.parse.NumberParseMatcher;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.impl.number.parse.ParsedNumber;
import java.util.ArrayList;
import java.util.List;

public class SeriesMatcher
implements NumberParseMatcher {
    protected List<NumberParseMatcher> matchers = null;
    protected boolean frozen = false;

    public void addMatcher(NumberParseMatcher matcher) {
        assert (!this.frozen);
        if (this.matchers == null) {
            this.matchers = new ArrayList<NumberParseMatcher>();
        }
        this.matchers.add(matcher);
    }

    public void freeze() {
        this.frozen = true;
    }

    public int length() {
        return this.matchers == null ? 0 : this.matchers.size();
    }

    @Override
    public boolean match(StringSegment segment, ParsedNumber result2) {
        assert (this.frozen);
        if (this.matchers == null) {
            return false;
        }
        ParsedNumber backup = new ParsedNumber();
        backup.copyFrom(result2);
        int initialOffset = segment.getOffset();
        boolean maybeMore = true;
        int i = 0;
        while (i < this.matchers.size()) {
            NumberParseMatcher matcher = this.matchers.get(i);
            int matcherOffset = segment.getOffset();
            maybeMore = segment.length() != 0 ? matcher.match(segment, result2) : true;
            boolean success = segment.getOffset() != matcherOffset;
            boolean isFlexible = matcher instanceof NumberParseMatcher.Flexible;
            if (success && isFlexible) continue;
            if (success) {
                if (++i >= this.matchers.size() || segment.getOffset() == result2.charEnd || result2.charEnd <= matcherOffset) continue;
                segment.setOffset(result2.charEnd);
                continue;
            }
            if (isFlexible) {
                ++i;
                continue;
            }
            segment.setOffset(initialOffset);
            result2.copyFrom(backup);
            return maybeMore;
        }
        return maybeMore;
    }

    @Override
    public boolean smokeTest(StringSegment segment) {
        assert (this.frozen);
        if (this.matchers == null) {
            return false;
        }
        assert (!(this.matchers.get(0) instanceof NumberParseMatcher.Flexible));
        return this.matchers.get(0).smokeTest(segment);
    }

    @Override
    public void postProcess(ParsedNumber result2) {
        assert (this.frozen);
        if (this.matchers == null) {
            return;
        }
        for (int i = 0; i < this.matchers.size(); ++i) {
            NumberParseMatcher matcher = this.matchers.get(i);
            matcher.postProcess(result2);
        }
    }

    public String toString() {
        return "<SeriesMatcher " + this.matchers + ">";
    }
}

