/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.message2;

import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.message2.Directionality;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.util.ULocale;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class OptUtils {
    private static final Pattern RE_NUMBER_LITERAL = Pattern.compile("^-?(0|[1-9][0-9]*)(\\.[0-9]+)?([eE][+\\-]?[0-9]+)?$");

    private OptUtils() {
    }

    static Number asNumber(Object value2) {
        if (value2 instanceof Number) {
            return (Number)value2;
        }
        if (value2 instanceof CharSequence) {
            try {
                Matcher m = RE_NUMBER_LITERAL.matcher(value2.toString());
                if (m.find()) {
                    return Double.parseDouble(value2.toString());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    static Number asNumber(boolean reportErrors, String keyName, Object value2) {
        if (value2 instanceof Number) {
            return (Number)value2;
        }
        if (value2 instanceof CharSequence) {
            try {
                Matcher m = RE_NUMBER_LITERAL.matcher(value2.toString());
                if (m.find()) {
                    return Double.parseDouble(value2.toString());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (reportErrors) {
            throw new IllegalArgumentException("bad-operand: " + keyName + " must be numeric");
        }
        return null;
    }

    static Integer getInteger(Map<String, Object> options2, boolean reportErrors, String key) {
        Object value2 = options2.get(key);
        if (value2 == null) {
            return null;
        }
        Number nrValue = OptUtils.asNumber(reportErrors, key, value2);
        if (nrValue != null) {
            return nrValue.intValue();
        }
        return null;
    }

    static String getString(Map<String, Object> options2, String key, String defaultVal) {
        Object value2 = options2.get(key);
        if (value2 instanceof CharSequence) {
            return value2.toString();
        }
        return defaultVal;
    }

    static String getString(Map<String, Object> options2, String key) {
        return OptUtils.getString(options2, key, null);
    }

    static boolean reportErrors(Map<String, Object> options2) {
        String reportErrors = OptUtils.getString(options2, "icu:impl:errorPolicy");
        return "STRICT".equals(reportErrors);
    }

    static boolean reportErrors(Map<String, Object> fixedOptions, Map<String, Object> variableOptions) {
        return OptUtils.reportErrors(fixedOptions) || OptUtils.reportErrors(variableOptions);
    }

    static Locale getBestLocale(Map<String, Object> options2, Locale defaultValue) {
        Locale result2;
        block4: {
            result2 = null;
            String localeOverride = OptUtils.getString(options2, "u:locale");
            if (localeOverride != null) {
                try {
                    result2 = Locale.forLanguageTag(localeOverride.replace('_', '-'));
                }
                catch (Exception e) {
                    if (!OptUtils.reportErrors(options2)) break block4;
                    throw new IllegalArgumentException("bad-operand: u:locale must be a valid BCP 47 language tag");
                }
            }
        }
        if (result2 == null) {
            result2 = defaultValue == null ? Locale.getDefault() : defaultValue;
        }
        return result2;
    }

    static Directionality getBestDirectionality(Map<String, Object> options2, Locale locale) {
        Directionality result2 = OptUtils.getDirectionality(options2);
        return result2 == Directionality.UNKNOWN ? Directionality.of(ULocale.forLocale(locale)) : result2;
    }

    static Directionality getDirectionality(Map<String, Object> options2) {
        Directionality result2;
        String value2 = OptUtils.getString(options2, "u:dir");
        if (value2 == null) {
            return Directionality.UNKNOWN;
        }
        switch (value2) {
            case "rtl": {
                result2 = Directionality.RTL;
                break;
            }
            case "ltr": {
                result2 = Directionality.LTR;
                break;
            }
            case "auto": {
                result2 = Directionality.AUTO;
                break;
            }
            case "inherit": {
                result2 = Directionality.INHERIT;
                break;
            }
            default: {
                result2 = Directionality.UNKNOWN;
            }
        }
        return result2;
    }

    static String getUId(Map<String, Object> options2) {
        return OptUtils.getString(options2, "u:id");
    }
}

