/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.text;

import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.text.NFRuleSet;
import io.github.quiltservertools.blockbotdiscord.libs.com.ibm.icu.text.NFSubstitution;
import java.text.ParsePosition;

class NumeratorSubstitution
extends NFSubstitution {
    private final double denominator;
    private final boolean withZeros;

    NumeratorSubstitution(int pos, double denominator, NFRuleSet ruleSet, String description2) {
        super(pos, ruleSet, NumeratorSubstitution.fixdesc(description2));
        this.denominator = denominator;
        this.withZeros = description2.endsWith("<<");
    }

    static String fixdesc(String description2) {
        return description2.endsWith("<<") ? description2.substring(0, description2.length() - 1) : description2;
    }

    @Override
    public boolean equals(Object that) {
        if (super.equals(that)) {
            NumeratorSubstitution that2 = (NumeratorSubstitution)that;
            return this.denominator == that2.denominator && this.withZeros == that2.withZeros;
        }
        return false;
    }

    @Override
    public void doSubstitution(double number, StringBuilder toInsertInto, int position2, int recursionCount) {
        double numberToFormat = this.transformNumber(number);
        if (this.withZeros && this.ruleSet != null) {
            long nf = (long)numberToFormat;
            int len = toInsertInto.length();
            while (true) {
                long l;
                nf *= 10L;
                if (!((double)l < this.denominator)) break;
                toInsertInto.insert(position2 + this.pos, ' ');
                this.ruleSet.format(0L, toInsertInto, position2 + this.pos, recursionCount);
            }
            position2 += toInsertInto.length() - len;
        }
        if (numberToFormat == Math.floor(numberToFormat) && this.ruleSet != null) {
            this.ruleSet.format((long)numberToFormat, toInsertInto, position2 + this.pos, recursionCount);
        } else if (this.ruleSet != null) {
            this.ruleSet.format(numberToFormat, toInsertInto, position2 + this.pos, recursionCount);
        } else {
            toInsertInto.insert(position2 + this.pos, this.numberFormat.format(numberToFormat));
        }
    }

    @Override
    public long transformNumber(long number) {
        return Math.round((double)number * this.denominator);
    }

    @Override
    public double transformNumber(double number) {
        return Math.round(number * this.denominator);
    }

    @Override
    public Number doParse(String text, ParsePosition parsePosition, double baseValue, double upperBound, boolean lenientParse, int nonNumericalExecutedRuleMask, int recursionCount) {
        int zeroCount = 0;
        if (this.withZeros) {
            String workText = text;
            ParsePosition workPos = new ParsePosition(1);
            while (workText.length() > 0 && workPos.getIndex() != 0) {
                workPos.setIndex(0);
                this.ruleSet.parse(workText, workPos, 1.0, nonNumericalExecutedRuleMask, recursionCount).intValue();
                if (workPos.getIndex() == 0) break;
                ++zeroCount;
                parsePosition.setIndex(parsePosition.getIndex() + workPos.getIndex());
                workText = workText.substring(workPos.getIndex());
                while (workText.length() > 0 && workText.charAt(0) == ' ') {
                    workText = workText.substring(1);
                    parsePosition.setIndex(parsePosition.getIndex() + 1);
                }
            }
            text = text.substring(parsePosition.getIndex());
            parsePosition.setIndex(0);
        }
        Number result2 = super.doParse(text, parsePosition, this.withZeros ? 1.0 : baseValue, upperBound, false, nonNumericalExecutedRuleMask, recursionCount);
        if (this.withZeros) {
            long d;
            long n = result2.longValue();
            for (d = 1L; d <= n; d *= 10L) {
            }
            while (zeroCount > 0) {
                d *= 10L;
                --zeroCount;
            }
            result2 = (double)n / (double)d;
        }
        return result2;
    }

    @Override
    public double composeRuleValue(double newRuleValue, double oldRuleValue) {
        return newRuleValue / oldRuleValue;
    }

    @Override
    public double calcUpperBound(double oldUpperBound) {
        return this.denominator;
    }

    @Override
    char tokenChar() {
        return '<';
    }
}

