/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.vdurmont.emoji;

import io.github.quiltservertools.blockbotdiscord.libs.com.vdurmont.emoji.Emoji;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmojiTrie {
    private final Node root = new Node();
    final int maxDepth;

    public EmojiTrie(Collection<Emoji> emojis2) {
        int maxDepth = 0;
        for (Emoji emoji2 : emojis2) {
            Node tree2 = this.root;
            char[] chars = emoji2.getUnicode().toCharArray();
            maxDepth = Math.max(maxDepth, chars.length);
            for (char c : chars) {
                if (!tree2.hasChild(c)) {
                    tree2.addChild(c);
                }
                tree2 = tree2.getChild(c);
            }
            tree2.setEmoji(emoji2);
        }
        this.maxDepth = maxDepth;
    }

    public Matches isEmoji(char[] sequence2) {
        return this.isEmoji(sequence2, 0, sequence2.length);
    }

    public Matches isEmoji(char[] sequence2, int start2, int end) {
        if (start2 < 0 || start2 > end || end > sequence2.length) {
            throw new ArrayIndexOutOfBoundsException("start " + start2 + ", end " + end + ", length " + sequence2.length);
        }
        if (sequence2 == null) {
            return Matches.POSSIBLY;
        }
        Node tree2 = this.root;
        for (int i = start2; i < end; ++i) {
            if (!tree2.hasChild(sequence2[i])) {
                return Matches.IMPOSSIBLE;
            }
            tree2 = tree2.getChild(sequence2[i]);
        }
        return tree2.isEndOfEmoji() ? Matches.EXACTLY : Matches.POSSIBLY;
    }

    public Emoji getEmoji(String unicode) {
        return this.getEmoji(unicode.toCharArray(), 0, unicode.length());
    }

    Emoji getEmoji(char[] sequence2, int start2, int end) {
        if (start2 < 0 || start2 > end || end > sequence2.length) {
            throw new ArrayIndexOutOfBoundsException("start " + start2 + ", end " + end + ", length " + sequence2.length);
        }
        Node tree2 = this.root;
        for (int i = 0; i < end; ++i) {
            if (!tree2.hasChild(sequence2[i])) {
                return null;
            }
            tree2 = tree2.getChild(sequence2[i]);
        }
        return tree2.getEmoji();
    }

    private class Node {
        private Map<Character, Node> children = new HashMap<Character, Node>();
        private Emoji emoji;

        private Node() {
        }

        private void setEmoji(Emoji emoji2) {
            this.emoji = emoji2;
        }

        private Emoji getEmoji() {
            return this.emoji;
        }

        private boolean hasChild(char child) {
            return this.children.containsKey(Character.valueOf(child));
        }

        private void addChild(char child) {
            this.children.put(Character.valueOf(child), new Node());
        }

        private Node getChild(char child) {
            return this.children.get(Character.valueOf(child));
        }

        private boolean isEndOfEmoji() {
            return this.emoji != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Matches {
        EXACTLY,
        POSSIBLY,
        IMPOSSIBLE;


        public boolean exactMatch() {
            return this == EXACTLY;
        }

        public boolean impossibleMatch() {
            return this == IMPOSSIBLE;
        }
    }
}

