/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.dev.kordex.core.commands.application.slash;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import io.github.quiltservertools.blockbotdiscord.libs.dev.kordex.core.InvalidCommandException;
import io.github.quiltservertools.blockbotdiscord.libs.dev.kordex.core.commands.application.ApplicationCommand;
import io.github.quiltservertools.blockbotdiscord.libs.dev.kordex.core.commands.application.Localised;
import io.github.quiltservertools.blockbotdiscord.libs.dev.kordex.core.commands.application.slash.SlashCommand;
import io.github.quiltservertools.blockbotdiscord.libs.dev.kordex.core.i18n.types.Key;
import io.github.quiltservertools.blockbotdiscord.libs.dev.kordex.core.koin.KordExKoinComponent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0005\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R#\u0010\u0005\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0017\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR)\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00040\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\"\u0010 \u001a\u00020\u00028\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b \u0010\u0010\u001a\u0004\b!\u0010\u0012\"\u0004\b\"\u0010#R!\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0$8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R!\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0$8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010&\u001a\u0004\b+\u0010(R#\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0-8\u0006\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\u00a8\u00062"}, d2={"Lio/github/quiltservertools/blockbotdiscord/libs/dev/kordex/core/commands/application/slash/SlashGroup;", "Lio/github/quiltservertools/blockbotdiscord/libs/dev/kordex/core/koin/KordExKoinComponent;", "Lio/github/quiltservertools/blockbotdiscord/libs/dev/kordex/core/i18n/types/Key;", "name", "Lio/github/quiltservertools/blockbotdiscord/libs/dev/kordex/core/commands/application/slash/SlashCommand;", "parent", "<init>", "(Ldev/kordex/core/i18n/types/Key;Ldev/kordex/core/commands/application/slash/SlashCommand;)V", "Ljava/util/Locale;", "locale", "", "getTranslatedDescription", "(Ljava/util/Locale;)Ljava/lang/String;", "", "validate", "()V", "Lio/github/quiltservertools/blockbotdiscord/libs/dev/kordex/core/i18n/types/Key;", "getName", "()Ldev/kordex/core/i18n/types/Key;", "Lio/github/quiltservertools/blockbotdiscord/libs/dev/kordex/core/commands/application/slash/SlashCommand;", "getParent", "()Ldev/kordex/core/commands/application/slash/SlashCommand;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "getLogger", "()Lio/github/oshai/kotlinlogging/KLogger;", "", "subCommands", "Ljava/util/List;", "getSubCommands", "()Ljava/util/List;", "description", "getDescription", "setDescription", "(Ldev/kordex/core/i18n/types/Key;)V", "Lio/github/quiltservertools/blockbotdiscord/libs/dev/kordex/core/commands/application/Localised;", "localisedName$delegate", "Lkotlin/Lazy;", "getLocalisedName", "()Ldev/kordex/core/commands/application/Localised;", "localisedName", "localisedDescription$delegate", "getLocalisedDescription", "localisedDescription", "", "descriptionTranslationCache", "Ljava/util/Map;", "getDescriptionTranslationCache", "()Ljava/util/Map;", "kord-extensions"})
public final class SlashGroup
implements KordExKoinComponent {
    @NotNull
    private final Key name;
    @NotNull
    private final SlashCommand<?, ?, ?> parent;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final List<SlashCommand<?, ?, ?>> subCommands;
    public Key description;
    @NotNull
    private final Lazy localisedName$delegate;
    @NotNull
    private final Lazy localisedDescription$delegate;
    @NotNull
    private final Map<Locale, String> descriptionTranslationCache;

    public SlashGroup(@NotNull Key name2, @NotNull SlashCommand<?, ?, ?> parent) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        this.name = name2;
        this.parent = parent;
        this.logger = KotlinLogging.INSTANCE.logger((Function0<Unit>)((Function0)SlashGroup::logger$lambda$0));
        this.subCommands = new ArrayList();
        this.localisedName$delegate = LazyKt.lazy(() -> SlashGroup.localisedName_delegate$lambda$0(this));
        this.localisedDescription$delegate = LazyKt.lazy(() -> SlashGroup.localisedDescription_delegate$lambda$0(this));
        this.descriptionTranslationCache = new LinkedHashMap();
    }

    @NotNull
    public final Key getName() {
        return this.name;
    }

    @NotNull
    public final SlashCommand<?, ?, ?> getParent() {
        return this.parent;
    }

    @NotNull
    public final KLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final List<SlashCommand<?, ?, ?>> getSubCommands() {
        return this.subCommands;
    }

    @NotNull
    public final Key getDescription() {
        Key key = this.description;
        if (key != null) {
            return key;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"description");
        return null;
    }

    public final void setDescription(@NotNull Key key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"<set-?>");
        this.description = key;
    }

    @NotNull
    public final Localised<String> getLocalisedName() {
        Lazy lazy2 = this.localisedName$delegate;
        return (Localised)lazy2.getValue();
    }

    @NotNull
    public final Localised<String> getLocalisedDescription() {
        Lazy lazy2 = this.localisedDescription$delegate;
        return (Localised)lazy2.getValue();
    }

    @NotNull
    public final Map<Locale, String> getDescriptionTranslationCache() {
        return this.descriptionTranslationCache;
    }

    @NotNull
    public final String getTranslatedDescription(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        if (!this.descriptionTranslationCache.containsKey(locale)) {
            String string = Key.withLocale$default(this.getDescription(), locale, false, 2, null).translate(new Object[0]).toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            this.descriptionTranslationCache.put(locale, string);
        }
        String string = this.descriptionTranslationCache.get(locale);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public final void validate() {
        if (this.description == null) {
            throw new InvalidCommandException(this.name, "No group description given.");
        }
        if (this.subCommands.isEmpty()) {
            throw new IllegalStateException("Command groups must contain at least one subcommand.".toString());
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Localised localisedName_delegate$lambda$0(SlashGroup this$0) {
        return this$0.parent.localise(this$0.name, true);
    }

    private static final Localised localisedDescription_delegate$lambda$0(SlashGroup this$0) {
        return ApplicationCommand.localise$default(this$0.parent, this$0.getDescription(), false, 2, null);
    }
}

