/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.mcdiscordreserializer.minecraft;

import io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.mcdiscordreserializer.renderer.NodeRenderer;
import io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.mcdiscordreserializer.renderer.implementation.DefaultMinecraftRenderer;
import io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.mcdiscordreserializer.rules.DiscordMarkdownRules;
import io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.simpleast.core.node.Node;
import io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.simpleast.core.parser.Parser;
import io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.simpleast.core.parser.Rule;
import io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.simpleast.core.simple.SimpleMarkdownRules;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinecraftSerializerOptions<O> {
    @NotNull
    private final Parser<Object, Node<Object>, Object> parser;
    @Nullable
    private final List<Rule<Object, Node<Object>, Object>> rules;
    @NotNull
    private final List<NodeRenderer<O>> renderers;
    private final boolean debuggingEnabled;

    public static MinecraftSerializerOptions<Component> defaults() {
        return new MinecraftSerializerOptions<Component>(new Parser<Object, Node<Object>, Object>(), DiscordMarkdownRules.createAllRulesForDiscord(true), Collections.emptyList(), false);
    }

    @Deprecated
    public static MinecraftSerializerOptions<String> escapeDefaults() {
        ArrayList<Rule<Object, Node<Object>, Object>> rules = new ArrayList<Rule<Object, Node<Object>, Object>>();
        rules.addAll(SimpleMarkdownRules.createSimpleMarkdownRules(false));
        rules.addAll(DiscordMarkdownRules.createStyleRules());
        rules.add(SimpleMarkdownRules.createTextRule());
        return new MinecraftSerializerOptions<String>(new Parser<Object, Node<Object>, Object>(), rules, Collections.emptyList(), false);
    }

    @NotNull
    public MinecraftSerializerOptions<O> addRenderer(@NotNull NodeRenderer<O> renderer) {
        if (this.renderers.contains(renderer)) {
            throw new IllegalArgumentException("The provided renderer is already included in this options instance");
        }
        if (renderer.getClass().equals(DefaultMinecraftRenderer.class)) {
            throw new IllegalArgumentException("DefaultMinecraftRenderer cannot be added to serializer options");
        }
        ArrayList<NodeRenderer<O>> renderers = new ArrayList<NodeRenderer<O>>(this.renderers);
        renderers.add(renderer);
        return new MinecraftSerializerOptions<O>(this.parser, this.rules, renderers, this.debuggingEnabled);
    }

    @NotNull
    public MinecraftSerializerOptions<O> addRenderer(int index, @NotNull NodeRenderer<O> renderer) {
        if (this.renderers.contains(renderer)) {
            throw new IllegalArgumentException("The provided renderer is already included in this options instance");
        }
        if (renderer.getClass().equals(DefaultMinecraftRenderer.class)) {
            throw new IllegalArgumentException("DefaultMinecraftRenderer cannot be added to serializer options");
        }
        ArrayList<NodeRenderer<O>> renderers = new ArrayList<NodeRenderer<O>>(this.renderers);
        renderers.add(index, renderer);
        return new MinecraftSerializerOptions<O>(this.parser, this.rules, renderers, this.debuggingEnabled);
    }

    public MinecraftSerializerOptions<O> removeRenderer(NodeRenderer<O> renderer) {
        if (!this.renderers.contains(renderer)) {
            throw new IllegalArgumentException("The provided renderer is not included in this options instance");
        }
        ArrayList<NodeRenderer<O>> renderers = new ArrayList<NodeRenderer<O>>(this.renderers);
        renderers.remove(renderer);
        return new MinecraftSerializerOptions<O>(this.parser, this.rules, renderers, this.debuggingEnabled);
    }

    @NotNull
    public List<NodeRenderer<O>> getRenderers() {
        return Collections.unmodifiableList(this.renderers);
    }

    public MinecraftSerializerOptions(@NotNull Parser<Object, Node<Object>, Object> parser, @Nullable List<Rule<Object, Node<Object>, Object>> rules, @NotNull List<NodeRenderer<O>> renderers, boolean debuggingEnabled) {
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        if (renderers == null) {
            throw new NullPointerException("renderers is marked non-null but is null");
        }
        this.parser = parser;
        this.rules = rules;
        this.renderers = renderers;
        this.debuggingEnabled = debuggingEnabled;
    }

    public String toString() {
        return "MinecraftSerializerOptions(parser=" + this.getParser() + ", rules=" + this.getRules() + ", renderers=" + this.getRenderers() + ", debuggingEnabled=" + this.isDebuggingEnabled() + ")";
    }

    public MinecraftSerializerOptions<O> withParser(@NotNull Parser<Object, Node<Object>, Object> parser) {
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        return this.parser == parser ? this : new MinecraftSerializerOptions<O>(parser, this.rules, this.renderers, this.debuggingEnabled);
    }

    @NotNull
    public Parser<Object, Node<Object>, Object> getParser() {
        return this.parser;
    }

    public MinecraftSerializerOptions<O> withRules(@Nullable List<Rule<Object, Node<Object>, Object>> rules) {
        return this.rules == rules ? this : new MinecraftSerializerOptions<O>(this.parser, rules, this.renderers, this.debuggingEnabled);
    }

    @Nullable
    public List<Rule<Object, Node<Object>, Object>> getRules() {
        return this.rules;
    }

    public MinecraftSerializerOptions<O> withDebuggingEnabled(boolean debuggingEnabled) {
        return this.debuggingEnabled == debuggingEnabled ? this : new MinecraftSerializerOptions<O>(this.parser, this.rules, this.renderers, debuggingEnabled);
    }

    public boolean isDebuggingEnabled() {
        return this.debuggingEnabled;
    }
}

