/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.mcdiscordreserializer.renderer;

import io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.mcdiscordreserializer.minecraft.MinecraftSerializerOptions;
import io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.mcdiscordreserializer.renderer.MinecraftNodeRenderer;
import io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.mcdiscordreserializer.rules.DiscordMarkdownRules;
import io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.simpleast.core.TextStyle;
import io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.simpleast.core.node.Node;
import io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.simpleast.core.node.StyleNode;
import io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.simpleast.core.node.TextNode;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.Component;
import io.github.quiltservertools.blockbotdiscord.libs.net.kyori.adventure.text.TextComponent;
import java.util.ArrayList;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MinecraftRenderer
extends MinecraftNodeRenderer {
    @Override
    default public Component render(@NotNull Component component, @NotNull Node<Object> node, @NotNull MinecraftSerializerOptions<Component> serializerOptions, @NotNull Function<Node<Object>, Component> renderWithChildren) {
        if (node instanceof TextNode) {
            component = ((TextComponent)component).content(((TextNode)node).getContent());
        } else if (node instanceof StyleNode) {
            ArrayList styles = new ArrayList(((StyleNode)node).getStyles());
            for (TextStyle style : styles) {
                switch (style.getType()) {
                    case LINK: {
                        component = this.link(component, style.getExtra().get("link"));
                        break;
                    }
                    case STRIKETHROUGH: {
                        component = this.strikethrough(component);
                        break;
                    }
                    case UNDERLINE: {
                        component = this.underline(component);
                        break;
                    }
                    case ITALICS: {
                        component = this.italics(component);
                        break;
                    }
                    case BOLD: {
                        component = this.bold(component);
                        break;
                    }
                    case CODE_STRING: {
                        component = this.codeString(component);
                        ((StyleNode)node).getStyles().remove(style);
                        break;
                    }
                    case CODE_BLOCK: {
                        component = this.codeBlock(component);
                        ((StyleNode)node).getStyles().remove(style);
                        break;
                    }
                    case QUOTE: {
                        TextComponent content2 = Component.empty();
                        for (Node<Object> objectNode : serializerOptions.getParser().parse(style.getExtra().get("content"), new DiscordMarkdownRules.QuoteState(true), serializerOptions.getRules(), serializerOptions.isDebuggingEnabled())) {
                            content2 = (TextComponent)content2.append(renderWithChildren.apply(objectNode));
                        }
                        component = this.appendQuote(component, content2);
                        break;
                    }
                    case SPOILER: {
                        TextComponent content2 = Component.empty();
                        for (Node<Object> objectNode : serializerOptions.getParser().parse(style.getExtra().get("content"), null, serializerOptions.getRules(), serializerOptions.isDebuggingEnabled())) {
                            content2 = (TextComponent)content2.append(renderWithChildren.apply(objectNode));
                        }
                        component = this.appendSpoiler(component, content2);
                        break;
                    }
                    case MENTION_EMOJI: {
                        component = this.appendEmoteMention(component, style.getExtra().get("name"), style.getExtra().get("id"));
                        break;
                    }
                    case MENTION_CHANNEL: {
                        component = this.appendChannelMention(component, style.getExtra().get("id"));
                        break;
                    }
                    case MENTION_USER: {
                        component = this.appendUserMention(component, style.getExtra().get("id"));
                        break;
                    }
                    case MENTION_ROLE: {
                        component = this.appendRoleMention(component, style.getExtra().get("id"));
                        break;
                    }
                }
                if (component != null) continue;
                break;
            }
        }
        return component;
    }

    public Component link(@NotNull Component var1, String var2);

    @Nullable
    public Component strikethrough(@NotNull Component var1);

    @Nullable
    public Component underline(@NotNull Component var1);

    @Nullable
    public Component italics(@NotNull Component var1);

    @Nullable
    public Component bold(@NotNull Component var1);

    @Nullable
    public Component codeString(@NotNull Component var1);

    @Nullable
    public Component codeBlock(@NotNull Component var1);

    @Nullable
    public Component appendSpoiler(@NotNull Component var1, @NotNull Component var2);

    @Nullable
    public Component appendQuote(@NotNull Component var1, @NotNull Component var2);

    @Nullable
    public Component appendEmoteMention(@NotNull Component var1, @NotNull String var2, @NotNull String var3);

    @Nullable
    public Component appendChannelMention(@NotNull Component var1, @NotNull String var2);

    @Nullable
    public Component appendUserMention(@NotNull Component var1, @NotNull String var2);

    @Nullable
    public Component appendRoleMention(@NotNull Component var1, @NotNull String var2);
}

