/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.simpleast.core.parser;

import io.github.quiltservertools.blockbotdiscord.libs.dev.vankka.simpleast.core.node.Node;

public class ParseSpec<R, T extends Node<R>, S> {
    private T root;
    private boolean isTerminal;
    private S state;
    private int startIndex = 0;
    private int endIndex = 0;

    public ParseSpec(T root, S state2, int startIndex, int endIndex) {
        this.root = root;
        this.state = state2;
        this.isTerminal = false;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    private ParseSpec(T root, S state2) {
        this.root = root;
        this.state = state2;
        this.isTerminal = true;
    }

    public void applyOffset(int offset) {
        this.startIndex += offset;
        this.endIndex += offset;
    }

    public T getRoot() {
        return this.root;
    }

    public boolean isTerminal() {
        return this.isTerminal;
    }

    public S getState() {
        return this.state;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public static <R, T extends Node<R>, S> ParseSpec<R, T, S> createNonterminal(T node, S state2, int startIndex, int endIndex) {
        return new ParseSpec<R, T, S>(node, state2, startIndex, endIndex);
    }

    public static <R, T extends Node<R>, S> ParseSpec<R, T, S> createTerminal(T node, S state2) {
        return new ParseSpec<R, T, S>(node, state2);
    }
}

