/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.ktor.http;

import io.github.quiltservertools.blockbotdiscord.libs.io.ktor.http.CookieDateParser;
import io.github.quiltservertools.blockbotdiscord.libs.io.ktor.http.InvalidCookieDateException;
import io.github.quiltservertools.blockbotdiscord.libs.io.ktor.util.date.GMTDate;
import io.github.quiltservertools.blockbotdiscord.libs.io.ktor.util.date.GMTDateParser;
import io.github.quiltservertools.blockbotdiscord.libs.io.ktor.util.date.InvalidDateStringException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0004\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0003\u001a\u0011\u0010\u0005\u001a\u00020\u0000*\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u001b\u0010\t\u001a\u00020\u0000*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\n\"\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"", "Lio/github/quiltservertools/blockbotdiscord/libs/io/ktor/util/date/GMTDate;", "fromHttpToGmtDate", "(Ljava/lang/String;)Lio/ktor/util/date/GMTDate;", "fromCookieToGmtDate", "toHttpDate", "(Lio/ktor/util/date/GMTDate;)Ljava/lang/String;", "", "length", "padZero", "(II)Ljava/lang/String;", "", "HTTP_DATE_FORMATS", "Ljava/util/List;", "ktor-http"})
public final class DateUtilsKt {
    @NotNull
    private static final List<String> HTTP_DATE_FORMATS;

    @NotNull
    public static final GMTDate fromHttpToGmtDate(@NotNull String $this$fromHttpToGmtDate) {
        Intrinsics.checkNotNullParameter((Object)$this$fromHttpToGmtDate, (String)"<this>");
        String $this$fromHttpToGmtDate_u24lambda_u240 = ((Object)StringsKt.trim((CharSequence)$this$fromHttpToGmtDate)).toString();
        boolean bl = false;
        for (String format : HTTP_DATE_FORMATS) {
            try {
                GMTDateParser parser = new GMTDateParser(format);
                return parser.parse($this$fromHttpToGmtDate);
            }
            catch (InvalidDateStringException invalidDateStringException) {
            }
        }
        throw new IllegalStateException(("Failed to parse date: " + $this$fromHttpToGmtDate_u24lambda_u240).toString());
    }

    @NotNull
    public static final GMTDate fromCookieToGmtDate(@NotNull String $this$fromCookieToGmtDate) {
        Intrinsics.checkNotNullParameter((Object)$this$fromCookieToGmtDate, (String)"<this>");
        String $this$fromCookieToGmtDate_u24lambda_u241 = ((Object)StringsKt.trim((CharSequence)$this$fromCookieToGmtDate)).toString();
        boolean bl = false;
        try {
            CookieDateParser parser = new CookieDateParser();
            return parser.parse($this$fromCookieToGmtDate_u24lambda_u241);
        }
        catch (InvalidCookieDateException invalidCookieDateException) {
            return DateUtilsKt.fromHttpToGmtDate($this$fromCookieToGmtDate_u24lambda_u241);
        }
    }

    @NotNull
    public static final String toHttpDate(@NotNull GMTDate $this$toHttpDate) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toHttpDate, (String)"<this>");
        StringBuilder $this$toHttpDate_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toHttpDate_u24lambda_u242.append($this$toHttpDate.getDayOfWeek().getValue() + ", ");
        $this$toHttpDate_u24lambda_u242.append(DateUtilsKt.padZero($this$toHttpDate.getDayOfMonth(), 2) + ' ');
        $this$toHttpDate_u24lambda_u242.append($this$toHttpDate.getMonth().getValue() + ' ');
        $this$toHttpDate_u24lambda_u242.append(DateUtilsKt.padZero($this$toHttpDate.getYear(), 4));
        $this$toHttpDate_u24lambda_u242.append(' ' + DateUtilsKt.padZero($this$toHttpDate.getHours(), 2) + ':' + DateUtilsKt.padZero($this$toHttpDate.getMinutes(), 2) + ':' + DateUtilsKt.padZero($this$toHttpDate.getSeconds(), 2) + ' ');
        $this$toHttpDate_u24lambda_u242.append("GMT");
        return stringBuilder.toString();
    }

    private static final String padZero(int $this$padZero, int length) {
        return StringsKt.padStart((String)String.valueOf($this$padZero), (int)length, (char)'0');
    }

    static {
        Object[] objectArray = new String[]{"***, dd MMM YYYY hh:mm:ss zzz", "****, dd-MMM-YYYY hh:mm:ss zzz", "*** MMM d hh:mm:ss YYYY", "***, dd-MMM-YYYY hh:mm:ss zzz", "***, dd-MMM-YYYY hh-mm-ss zzz", "***, dd MMM YYYY hh:mm:ss zzz", "*** dd-MMM-YYYY hh:mm:ss zzz", "*** dd MMM YYYY hh:mm:ss zzz", "*** dd-MMM-YYYY hh-mm-ss zzz", "***,dd-MMM-YYYY hh:mm:ss zzz", "*** MMM d YYYY hh:mm:ss zzz"};
        HTTP_DATE_FORMATS = CollectionsKt.listOf((Object[])objectArray);
    }
}

