/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class DiagnosticLogger
implements ILogger {
    @NotNull
    private final SentryOptions options;
    @Nullable
    private final ILogger logger;

    public DiagnosticLogger(@NotNull SentryOptions options2, @Nullable ILogger logger) {
        this.options = Objects.requireNonNull(options2, "SentryOptions is required.");
        this.logger = logger;
    }

    @Override
    public boolean isEnabled(@Nullable SentryLevel level) {
        SentryLevel diagLevel = this.options.getDiagnosticLevel();
        if (level == null) {
            return false;
        }
        return this.options.isDebug() && level.ordinal() >= diagLevel.ordinal();
    }

    @Override
    public void log(@NotNull SentryLevel level, @NotNull String message2, Object ... args) {
        if (this.logger != null && this.isEnabled(level)) {
            this.logger.log(level, message2, args);
        }
    }

    @Override
    public void log(@NotNull SentryLevel level, @NotNull String message2, @Nullable Throwable throwable) {
        if (this.logger != null && this.isEnabled(level)) {
            this.logger.log(level, message2, throwable);
        }
    }

    @Override
    public void log(@NotNull SentryLevel level, @Nullable Throwable throwable, @NotNull String message2, Object ... args) {
        if (this.logger != null && this.isEnabled(level)) {
            this.logger.log(level, throwable, message2, args);
        }
    }

    @TestOnly
    @Nullable
    public ILogger getLogger() {
        return this.logger;
    }
}

