/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.CheckIn;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Hint;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.IScope;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ProfileChunk;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ProfilingTraceData;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEnvelope;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLogEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLogEvents;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryReplayEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Session;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.TraceContext;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.UserFeedback;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Feedback;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Message;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryTransaction;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.transport.RateLimiter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ISentryClient {
    public boolean isEnabled();

    @NotNull
    public SentryId captureEvent(@NotNull SentryEvent var1, @Nullable IScope var2, @Nullable Hint var3);

    public void close();

    public void close(boolean var1);

    public void flush(long var1);

    @NotNull
    default public SentryId captureEvent(@NotNull SentryEvent event2) {
        return this.captureEvent(event2, null, null);
    }

    @NotNull
    default public SentryId captureEvent(@NotNull SentryEvent event2, @Nullable IScope scope) {
        return this.captureEvent(event2, scope, null);
    }

    @NotNull
    default public SentryId captureEvent(@NotNull SentryEvent event2, @Nullable Hint hint) {
        return this.captureEvent(event2, null, hint);
    }

    @NotNull
    public SentryId captureFeedback(@NotNull Feedback var1, @Nullable Hint var2, @NotNull IScope var3);

    @NotNull
    default public SentryId captureMessage(@NotNull String message2, @NotNull SentryLevel level, @Nullable IScope scope) {
        SentryEvent event2 = new SentryEvent();
        Message sentryMessage = new Message();
        sentryMessage.setFormatted(message2);
        event2.setMessage(sentryMessage);
        event2.setLevel(level);
        return this.captureEvent(event2, scope);
    }

    @NotNull
    default public SentryId captureMessage(@NotNull String message2, @NotNull SentryLevel level) {
        return this.captureMessage(message2, level, null);
    }

    @NotNull
    default public SentryId captureException(@NotNull Throwable throwable) {
        return this.captureException(throwable, null, null);
    }

    @NotNull
    default public SentryId captureException(@NotNull Throwable throwable, @Nullable IScope scope, @Nullable Hint hint) {
        SentryEvent event2 = new SentryEvent(throwable);
        return this.captureEvent(event2, scope, hint);
    }

    @NotNull
    default public SentryId captureException(@NotNull Throwable throwable, @Nullable Hint hint) {
        return this.captureException(throwable, null, hint);
    }

    @NotNull
    default public SentryId captureException(@NotNull Throwable throwable, @Nullable IScope scope) {
        return this.captureException(throwable, scope, null);
    }

    @NotNull
    public SentryId captureReplayEvent(@NotNull SentryReplayEvent var1, @Nullable IScope var2, @Nullable Hint var3);

    public void captureUserFeedback(@NotNull UserFeedback var1);

    public void captureSession(@NotNull Session var1, @Nullable Hint var2);

    default public void captureSession(@NotNull Session session) {
        this.captureSession(session, null);
    }

    @Nullable
    public SentryId captureEnvelope(@NotNull SentryEnvelope var1, @Nullable Hint var2);

    @Nullable
    default public SentryId captureEnvelope(@NotNull SentryEnvelope envelope) {
        return this.captureEnvelope(envelope, null);
    }

    @NotNull
    default public SentryId captureTransaction(@NotNull SentryTransaction transaction, @Nullable IScope scope, @Nullable Hint hint) {
        return this.captureTransaction(transaction, null, scope, hint);
    }

    @NotNull
    default public SentryId captureTransaction(@NotNull SentryTransaction transaction, @Nullable TraceContext traceContext, @Nullable IScope scope, @Nullable Hint hint) {
        return this.captureTransaction(transaction, traceContext, scope, hint, null);
    }

    @NotNull
    @ApiStatus.Internal
    public SentryId captureTransaction(@NotNull SentryTransaction var1, @Nullable TraceContext var2, @Nullable IScope var3, @Nullable Hint var4, @Nullable ProfilingTraceData var5);

    @ApiStatus.Internal
    @NotNull
    default public SentryId captureTransaction(@NotNull SentryTransaction transaction, @Nullable TraceContext traceContext) {
        return this.captureTransaction(transaction, traceContext, null, null);
    }

    @NotNull
    default public SentryId captureTransaction(@NotNull SentryTransaction transaction) {
        return this.captureTransaction(transaction, null, null, null);
    }

    @ApiStatus.Internal
    @NotNull
    public SentryId captureProfileChunk(@NotNull ProfileChunk var1, @Nullable IScope var2);

    @NotNull
    @ApiStatus.Experimental
    public SentryId captureCheckIn(@NotNull CheckIn var1, @Nullable IScope var2, @Nullable Hint var3);

    @ApiStatus.Experimental
    public void captureLog(@NotNull SentryLogEvent var1, @Nullable IScope var2);

    @ApiStatus.Internal
    public void captureBatchedLogEvents(@NotNull SentryLogEvents var1);

    @ApiStatus.Internal
    @Nullable
    public RateLimiter getRateLimiter();

    @ApiStatus.Internal
    default public boolean isHealthy() {
        return true;
    }
}

