/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.MonitorSchedule;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ScopesAdapter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class MonitorConfig
implements JsonUnknown,
JsonSerializable {
    @NotNull
    private MonitorSchedule schedule;
    @Nullable
    private Long checkinMargin;
    @Nullable
    private Long maxRuntime;
    @Nullable
    private String timezone;
    @Nullable
    private Long failureIssueThreshold;
    @Nullable
    private Long recoveryThreshold;
    @Nullable
    private Map<String, Object> unknown;

    public MonitorConfig(@NotNull MonitorSchedule schedule2) {
        this.schedule = schedule2;
        SentryOptions.Cron defaultCron = ScopesAdapter.getInstance().getOptions().getCron();
        if (defaultCron != null) {
            this.checkinMargin = defaultCron.getDefaultCheckinMargin();
            this.maxRuntime = defaultCron.getDefaultMaxRuntime();
            this.timezone = defaultCron.getDefaultTimezone();
            this.failureIssueThreshold = defaultCron.getDefaultFailureIssueThreshold();
            this.recoveryThreshold = defaultCron.getDefaultRecoveryThreshold();
        }
    }

    @NotNull
    public MonitorSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(@NotNull MonitorSchedule schedule2) {
        this.schedule = schedule2;
    }

    @Nullable
    public Long getCheckinMargin() {
        return this.checkinMargin;
    }

    public void setCheckinMargin(@Nullable Long checkinMargin) {
        this.checkinMargin = checkinMargin;
    }

    @Nullable
    public Long getMaxRuntime() {
        return this.maxRuntime;
    }

    public void setMaxRuntime(@Nullable Long maxRuntime) {
        this.maxRuntime = maxRuntime;
    }

    @Nullable
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(@Nullable String timezone) {
        this.timezone = timezone;
    }

    @Nullable
    public Long getFailureIssueThreshold() {
        return this.failureIssueThreshold;
    }

    public void setFailureIssueThreshold(@Nullable Long failureIssueThreshold) {
        this.failureIssueThreshold = failureIssueThreshold;
    }

    @Nullable
    public Long getRecoveryThreshold() {
        return this.recoveryThreshold;
    }

    public void setRecoveryThreshold(@Nullable Long recoveryThreshold) {
        this.recoveryThreshold = recoveryThreshold;
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        writer2.name("schedule");
        this.schedule.serialize(writer2, logger);
        if (this.checkinMargin != null) {
            writer2.name("checkin_margin").value(this.checkinMargin);
        }
        if (this.maxRuntime != null) {
            writer2.name("max_runtime").value(this.maxRuntime);
        }
        if (this.timezone != null) {
            writer2.name("timezone").value(this.timezone);
        }
        if (this.failureIssueThreshold != null) {
            writer2.name("failure_issue_threshold").value(this.failureIssueThreshold);
        }
        if (this.recoveryThreshold != null) {
            writer2.name("recovery_threshold").value(this.recoveryThreshold);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key).value(logger, value2);
            }
        }
        writer2.endObject();
    }

    public static final class JsonKeys {
        public static final String SCHEDULE = "schedule";
        public static final String CHECKIN_MARGIN = "checkin_margin";
        public static final String MAX_RUNTIME = "max_runtime";
        public static final String TIMEZONE = "timezone";
        public static final String FAILURE_ISSUE_THRESHOLD = "failure_issue_threshold";
        public static final String RECOVERY_THRESHOLD = "recovery_threshold";
    }

    public static final class Deserializer
    implements JsonDeserializer<MonitorConfig> {
        @Override
        @NotNull
        public MonitorConfig deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            MonitorSchedule schedule2 = null;
            Long checkinMargin = null;
            Long maxRuntime = null;
            String timezone = null;
            Long failureIssureThreshold = null;
            Long recoveryThreshold = null;
            HashMap<String, Object> unknown = null;
            reader2.beginObject();
            block16: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "schedule": {
                        schedule2 = new MonitorSchedule.Deserializer().deserialize(reader2, logger);
                        continue block16;
                    }
                    case "checkin_margin": {
                        checkinMargin = reader2.nextLongOrNull();
                        continue block16;
                    }
                    case "max_runtime": {
                        maxRuntime = reader2.nextLongOrNull();
                        continue block16;
                    }
                    case "timezone": {
                        timezone = reader2.nextStringOrNull();
                        continue block16;
                    }
                    case "failure_issue_threshold": {
                        failureIssureThreshold = reader2.nextLongOrNull();
                        continue block16;
                    }
                    case "recovery_threshold": {
                        recoveryThreshold = reader2.nextLongOrNull();
                        continue block16;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            reader2.endObject();
            if (schedule2 == null) {
                String message2 = "Missing required field \"schedule\"";
                IllegalStateException exception = new IllegalStateException(message2);
                logger.log(SentryLevel.ERROR, message2, exception);
                throw exception;
            }
            MonitorConfig monitorConfig = new MonitorConfig(schedule2);
            monitorConfig.setCheckinMargin(checkinMargin);
            monitorConfig.setMaxRuntime(maxRuntime);
            monitorConfig.setTimezone(timezone);
            monitorConfig.setFailureIssueThreshold(failureIssureThreshold);
            monitorConfig.setRecoveryThreshold(recoveryThreshold);
            monitorConfig.setUnknown(unknown);
            return monitorConfig;
        }
    }
}

