/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanContext;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class MonitorContexts
extends ConcurrentHashMap<String, Object>
implements JsonSerializable {
    private static final long serialVersionUID = 3987329379811822556L;

    public MonitorContexts() {
    }

    public MonitorContexts(@NotNull MonitorContexts contexts) {
        for (Map.Entry entry : contexts.entrySet()) {
            if (entry == null) continue;
            Object value2 = entry.getValue();
            if ("trace".equals(entry.getKey()) && value2 instanceof SpanContext) {
                this.setTrace(new SpanContext((SpanContext)value2));
                continue;
            }
            this.put((String)entry.getKey(), value2);
        }
    }

    @Nullable
    private <T> T toContextType(@NotNull String key, @NotNull Class<T> clazz) {
        Object item2 = this.get(key);
        return clazz.isInstance(item2) ? (T)clazz.cast(item2) : null;
    }

    @Nullable
    public SpanContext getTrace() {
        return this.toContextType("trace", SpanContext.class);
    }

    public void setTrace(@NotNull SpanContext traceContext) {
        Objects.requireNonNull(traceContext, "traceContext is required");
        this.put("trace", traceContext);
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        ArrayList<String> sortedKeys = Collections.list(this.keys());
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            Object value2 = this.get(key);
            if (value2 == null) continue;
            writer2.name(key).value(logger, value2);
        }
        writer2.endObject();
    }

    public static final class Deserializer
    implements JsonDeserializer<MonitorContexts> {
        @Override
        @NotNull
        public MonitorContexts deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            MonitorContexts contexts = new MonitorContexts();
            reader2.beginObject();
            block6: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "trace": {
                        contexts.setTrace(new SpanContext.Deserializer().deserialize(reader2, logger));
                        continue block6;
                    }
                }
                Object object = reader2.nextObjectOrNull();
                if (object == null) continue;
                contexts.put(nextName, object);
            }
            reader2.endObject();
            return contexts;
        }
    }
}

