/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Breadcrumb;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.exception.ExceptionMechanismException;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Contexts;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.DebugMeta;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Request;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SdkVersion;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.User;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.CollectionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SentryBaseEvent {
    public static final String DEFAULT_PLATFORM = "java";
    @Nullable
    private SentryId eventId;
    @NotNull
    private final Contexts contexts = new Contexts();
    @Nullable
    private SdkVersion sdk;
    @Nullable
    private Request request;
    @Nullable
    private Map<String, String> tags;
    @Nullable
    private String release;
    @Nullable
    private String environment;
    @Nullable
    private String platform;
    @Nullable
    private User user;
    @Nullable
    protected transient Throwable throwable;
    @Nullable
    private String serverName;
    @Nullable
    private String dist;
    @Nullable
    private List<Breadcrumb> breadcrumbs;
    @Nullable
    private DebugMeta debugMeta;
    @Nullable
    private Map<String, Object> extra;

    protected SentryBaseEvent(@NotNull SentryId eventId) {
        this.eventId = eventId;
    }

    protected SentryBaseEvent() {
        this(new SentryId());
    }

    @Nullable
    public SentryId getEventId() {
        return this.eventId;
    }

    public void setEventId(@Nullable SentryId eventId) {
        this.eventId = eventId;
    }

    @NotNull
    public Contexts getContexts() {
        return this.contexts;
    }

    @Nullable
    public SdkVersion getSdk() {
        return this.sdk;
    }

    public void setSdk(@Nullable SdkVersion sdk) {
        this.sdk = sdk;
    }

    @Nullable
    public Request getRequest() {
        return this.request;
    }

    public void setRequest(@Nullable Request request) {
        this.request = request;
    }

    @Nullable
    public Throwable getThrowable() {
        Throwable ex = this.throwable;
        if (ex instanceof ExceptionMechanismException) {
            return ((ExceptionMechanismException)ex).getThrowable();
        }
        return ex;
    }

    @ApiStatus.Internal
    @Nullable
    public Throwable getThrowableMechanism() {
        return this.throwable;
    }

    public void setThrowable(@Nullable Throwable throwable) {
        this.throwable = throwable;
    }

    @ApiStatus.Internal
    @Nullable
    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(@Nullable Map<String, String> tags2) {
        this.tags = CollectionUtils.newHashMap(tags2);
    }

    public void removeTag(@Nullable String key) {
        if (this.tags != null && key != null) {
            this.tags.remove(key);
        }
    }

    @Nullable
    public String getTag(@Nullable String key) {
        if (this.tags != null && key != null) {
            return this.tags.get(key);
        }
        return null;
    }

    public void setTag(@Nullable String key, @Nullable String value2) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        if (key == null) {
            return;
        }
        if (value2 == null) {
            this.removeTag(key);
        } else {
            this.tags.put(key, value2);
        }
    }

    @Nullable
    public String getRelease() {
        return this.release;
    }

    public void setRelease(@Nullable String release) {
        this.release = release;
    }

    @Nullable
    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(@Nullable String environment) {
        this.environment = environment;
    }

    @Nullable
    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(@Nullable String platform) {
        this.platform = platform;
    }

    @Nullable
    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(@Nullable String serverName) {
        this.serverName = serverName;
    }

    @Nullable
    public String getDist() {
        return this.dist;
    }

    public void setDist(@Nullable String dist) {
        this.dist = dist;
    }

    @Nullable
    public User getUser() {
        return this.user;
    }

    public void setUser(@Nullable User user2) {
        this.user = user2;
    }

    @Nullable
    public List<Breadcrumb> getBreadcrumbs() {
        return this.breadcrumbs;
    }

    public void setBreadcrumbs(@Nullable List<Breadcrumb> breadcrumbs) {
        this.breadcrumbs = CollectionUtils.newArrayList(breadcrumbs);
    }

    public void addBreadcrumb(@NotNull Breadcrumb breadcrumb2) {
        if (this.breadcrumbs == null) {
            this.breadcrumbs = new ArrayList<Breadcrumb>();
        }
        this.breadcrumbs.add(breadcrumb2);
    }

    @Nullable
    public DebugMeta getDebugMeta() {
        return this.debugMeta;
    }

    public void setDebugMeta(@Nullable DebugMeta debugMeta) {
        this.debugMeta = debugMeta;
    }

    @Nullable
    public Map<String, Object> getExtras() {
        return this.extra;
    }

    public void setExtras(@Nullable Map<String, Object> extra) {
        this.extra = CollectionUtils.newHashMap(extra);
    }

    public void setExtra(@Nullable String key, @Nullable Object value2) {
        if (this.extra == null) {
            this.extra = new HashMap<String, Object>();
        }
        if (key == null) {
            return;
        }
        if (value2 == null) {
            this.removeExtra(key);
        } else {
            this.extra.put(key, value2);
        }
    }

    public void removeExtra(@Nullable String key) {
        if (this.extra != null && key != null) {
            this.extra.remove(key);
        }
    }

    @Nullable
    public Object getExtra(@Nullable String key) {
        if (this.extra != null && key != null) {
            return this.extra.get(key);
        }
        return null;
    }

    public void addBreadcrumb(@Nullable String message2) {
        this.addBreadcrumb(new Breadcrumb(message2));
    }

    public static final class Deserializer {
        public boolean deserializeValue(@NotNull SentryBaseEvent baseEvent, @NotNull String nextName, @NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            switch (nextName) {
                case "event_id": {
                    baseEvent.eventId = reader2.nextOrNull(logger, new SentryId.Deserializer());
                    return true;
                }
                case "contexts": {
                    Contexts deserializedContexts = new Contexts.Deserializer().deserialize(reader2, logger);
                    baseEvent.contexts.putAll(deserializedContexts);
                    return true;
                }
                case "sdk": {
                    baseEvent.sdk = reader2.nextOrNull(logger, new SdkVersion.Deserializer());
                    return true;
                }
                case "request": {
                    baseEvent.request = reader2.nextOrNull(logger, new Request.Deserializer());
                    return true;
                }
                case "tags": {
                    Map deserializedTags = (Map)reader2.nextObjectOrNull();
                    baseEvent.tags = CollectionUtils.newConcurrentHashMap(deserializedTags);
                    return true;
                }
                case "release": {
                    baseEvent.release = reader2.nextStringOrNull();
                    return true;
                }
                case "environment": {
                    baseEvent.environment = reader2.nextStringOrNull();
                    return true;
                }
                case "platform": {
                    baseEvent.platform = reader2.nextStringOrNull();
                    return true;
                }
                case "user": {
                    baseEvent.user = reader2.nextOrNull(logger, new User.Deserializer());
                    return true;
                }
                case "server_name": {
                    baseEvent.serverName = reader2.nextStringOrNull();
                    return true;
                }
                case "dist": {
                    baseEvent.dist = reader2.nextStringOrNull();
                    return true;
                }
                case "breadcrumbs": {
                    baseEvent.breadcrumbs = reader2.nextListOrNull(logger, new Breadcrumb.Deserializer());
                    return true;
                }
                case "debug_meta": {
                    baseEvent.debugMeta = reader2.nextOrNull(logger, new DebugMeta.Deserializer());
                    return true;
                }
                case "extra": {
                    Map deserializedExtra = (Map)reader2.nextObjectOrNull();
                    baseEvent.extra = CollectionUtils.newConcurrentHashMap(deserializedExtra);
                    return true;
                }
            }
            return false;
        }
    }

    public static final class Serializer {
        public void serialize(@NotNull SentryBaseEvent baseEvent, @NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
            if (baseEvent.eventId != null) {
                writer2.name("event_id").value(logger, baseEvent.eventId);
            }
            writer2.name("contexts").value(logger, baseEvent.contexts);
            if (baseEvent.sdk != null) {
                writer2.name("sdk").value(logger, baseEvent.sdk);
            }
            if (baseEvent.request != null) {
                writer2.name("request").value(logger, baseEvent.request);
            }
            if (baseEvent.tags != null && !baseEvent.tags.isEmpty()) {
                writer2.name("tags").value(logger, baseEvent.tags);
            }
            if (baseEvent.release != null) {
                writer2.name("release").value(baseEvent.release);
            }
            if (baseEvent.environment != null) {
                writer2.name("environment").value(baseEvent.environment);
            }
            if (baseEvent.platform != null) {
                writer2.name("platform").value(baseEvent.platform);
            }
            if (baseEvent.user != null) {
                writer2.name("user").value(logger, baseEvent.user);
            }
            if (baseEvent.serverName != null) {
                writer2.name("server_name").value(baseEvent.serverName);
            }
            if (baseEvent.dist != null) {
                writer2.name("dist").value(baseEvent.dist);
            }
            if (baseEvent.breadcrumbs != null && !baseEvent.breadcrumbs.isEmpty()) {
                writer2.name("breadcrumbs").value(logger, baseEvent.breadcrumbs);
            }
            if (baseEvent.debugMeta != null) {
                writer2.name("debug_meta").value(logger, baseEvent.debugMeta);
            }
            if (baseEvent.extra != null && !baseEvent.extra.isEmpty()) {
                writer2.name("extra").value(logger, baseEvent.extra);
            }
        }
    }

    public static final class JsonKeys {
        public static final String EVENT_ID = "event_id";
        public static final String CONTEXTS = "contexts";
        public static final String SDK = "sdk";
        public static final String REQUEST = "request";
        public static final String TAGS = "tags";
        public static final String RELEASE = "release";
        public static final String ENVIRONMENT = "environment";
        public static final String PLATFORM = "platform";
        public static final String USER = "user";
        public static final String SERVER_NAME = "server_name";
        public static final String DIST = "dist";
        public static final String BREADCRUMBS = "breadcrumbs";
        public static final String DEBUG_META = "debug_meta";
        public static final String EXTRA = "extra";
    }
}

