/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.DateUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryBaseEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryValues;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Message;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryException;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryThread;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.CollectionUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SentryEvent
extends SentryBaseEvent
implements JsonUnknown,
JsonSerializable {
    @NotNull
    private Date timestamp;
    @Nullable
    private Message message;
    @Nullable
    private String logger;
    @Nullable
    private SentryValues<SentryThread> threads;
    @Nullable
    private SentryValues<SentryException> exception;
    @Nullable
    private SentryLevel level;
    @Nullable
    private String transaction;
    @Nullable
    private List<String> fingerprint;
    @Nullable
    private Map<String, Object> unknown;
    @Nullable
    private Map<String, String> modules;

    SentryEvent(@NotNull SentryId eventId, @NotNull Date timestamp2) {
        super(eventId);
        this.timestamp = timestamp2;
    }

    public SentryEvent(@Nullable Throwable throwable) {
        this();
        this.throwable = throwable;
    }

    public SentryEvent() {
        this(new SentryId(), DateUtils.getCurrentDateTime());
    }

    @TestOnly
    public SentryEvent(@NotNull Date timestamp2) {
        this(new SentryId(), timestamp2);
    }

    public Date getTimestamp() {
        return (Date)this.timestamp.clone();
    }

    public void setTimestamp(@NotNull Date timestamp2) {
        this.timestamp = timestamp2;
    }

    @Nullable
    public Message getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable Message message2) {
        this.message = message2;
    }

    @Nullable
    public String getLogger() {
        return this.logger;
    }

    public void setLogger(@Nullable String logger) {
        this.logger = logger;
    }

    @Nullable
    public List<SentryThread> getThreads() {
        if (this.threads != null) {
            return this.threads.getValues();
        }
        return null;
    }

    public void setThreads(@Nullable List<SentryThread> threads) {
        this.threads = new SentryValues<SentryThread>(threads);
    }

    @Nullable
    public List<SentryException> getExceptions() {
        return this.exception == null ? null : this.exception.getValues();
    }

    public void setExceptions(@Nullable List<SentryException> exception) {
        this.exception = new SentryValues<SentryException>(exception);
    }

    @Nullable
    public SentryLevel getLevel() {
        return this.level;
    }

    public void setLevel(@Nullable SentryLevel level) {
        this.level = level;
    }

    @Nullable
    public String getTransaction() {
        return this.transaction;
    }

    public void setTransaction(@Nullable String transaction) {
        this.transaction = transaction;
    }

    @Nullable
    public List<String> getFingerprints() {
        return this.fingerprint;
    }

    public void setFingerprints(@Nullable List<String> fingerprint) {
        this.fingerprint = fingerprint != null ? new ArrayList<String>(fingerprint) : null;
    }

    @Nullable
    Map<String, String> getModules() {
        return this.modules;
    }

    public void setModules(@Nullable Map<String, String> modules) {
        this.modules = CollectionUtils.newHashMap(modules);
    }

    public void setModule(@NotNull String key, @NotNull String value2) {
        if (this.modules == null) {
            this.modules = new HashMap<String, String>();
        }
        this.modules.put(key, value2);
    }

    public void removeModule(@NotNull String key) {
        if (this.modules != null) {
            this.modules.remove(key);
        }
    }

    @Nullable
    public String getModule(@NotNull String key) {
        if (this.modules != null) {
            return this.modules.get(key);
        }
        return null;
    }

    public boolean isCrashed() {
        return this.getUnhandledException() != null;
    }

    @Nullable
    public SentryException getUnhandledException() {
        if (this.exception != null) {
            for (SentryException e : this.exception.getValues()) {
                if (e.getMechanism() == null || e.getMechanism().isHandled() == null || e.getMechanism().isHandled().booleanValue()) continue;
                return e;
            }
        }
        return null;
    }

    public boolean isErrored() {
        return this.exception != null && !this.exception.getValues().isEmpty();
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        writer2.name("timestamp").value(logger, this.timestamp);
        if (this.message != null) {
            writer2.name("message").value(logger, this.message);
        }
        if (this.logger != null) {
            writer2.name("logger").value(this.logger);
        }
        if (this.threads != null && !this.threads.getValues().isEmpty()) {
            writer2.name("threads");
            writer2.beginObject();
            writer2.name("values").value(logger, this.threads.getValues());
            writer2.endObject();
        }
        if (this.exception != null && !this.exception.getValues().isEmpty()) {
            writer2.name("exception");
            writer2.beginObject();
            writer2.name("values").value(logger, this.exception.getValues());
            writer2.endObject();
        }
        if (this.level != null) {
            writer2.name("level").value(logger, this.level);
        }
        if (this.transaction != null) {
            writer2.name("transaction").value(this.transaction);
        }
        if (this.fingerprint != null) {
            writer2.name("fingerprint").value(logger, this.fingerprint);
        }
        if (this.modules != null) {
            writer2.name("modules").value(logger, this.modules);
        }
        new SentryBaseEvent.Serializer().serialize(this, writer2, logger);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class JsonKeys {
        public static final String TIMESTAMP = "timestamp";
        public static final String MESSAGE = "message";
        public static final String LOGGER = "logger";
        public static final String THREADS = "threads";
        public static final String EXCEPTION = "exception";
        public static final String LEVEL = "level";
        public static final String TRANSACTION = "transaction";
        public static final String FINGERPRINT = "fingerprint";
        public static final String MODULES = "modules";
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryEvent> {
        @Override
        @NotNull
        public SentryEvent deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            reader2.beginObject();
            SentryEvent event2 = new SentryEvent();
            ConcurrentHashMap<String, Object> unknown = null;
            SentryBaseEvent.Deserializer baseEventDeserializer = new SentryBaseEvent.Deserializer();
            block22: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "timestamp": {
                        Date deserializedTimestamp = reader2.nextDateOrNull(logger);
                        if (deserializedTimestamp == null) continue block22;
                        event2.timestamp = deserializedTimestamp;
                        continue block22;
                    }
                    case "message": {
                        event2.message = reader2.nextOrNull(logger, new Message.Deserializer());
                        continue block22;
                    }
                    case "logger": {
                        event2.logger = reader2.nextStringOrNull();
                        continue block22;
                    }
                    case "threads": {
                        reader2.beginObject();
                        reader2.nextName();
                        event2.threads = new SentryValues<SentryThread>(reader2.nextListOrNull(logger, new SentryThread.Deserializer()));
                        reader2.endObject();
                        continue block22;
                    }
                    case "exception": {
                        reader2.beginObject();
                        reader2.nextName();
                        event2.exception = new SentryValues<SentryException>(reader2.nextListOrNull(logger, new SentryException.Deserializer()));
                        reader2.endObject();
                        continue block22;
                    }
                    case "level": {
                        event2.level = reader2.nextOrNull(logger, new SentryLevel.Deserializer());
                        continue block22;
                    }
                    case "transaction": {
                        event2.transaction = reader2.nextStringOrNull();
                        continue block22;
                    }
                    case "fingerprint": {
                        List deserializedFingerprint = (List)reader2.nextObjectOrNull();
                        if (deserializedFingerprint == null) continue block22;
                        event2.fingerprint = deserializedFingerprint;
                        continue block22;
                    }
                    case "modules": {
                        Map deserializedModules = (Map)reader2.nextObjectOrNull();
                        event2.modules = CollectionUtils.newConcurrentHashMap(deserializedModules);
                        continue block22;
                    }
                }
                if (baseEventDeserializer.deserializeValue(event2, nextName, reader2, logger)) continue;
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            event2.setUnknown(unknown);
            reader2.endObject();
            return event2;
        }
    }
}

