/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Session;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.clientreport.ClientReport;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryTransaction;
import java.io.IOException;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public enum SentryItemType implements JsonSerializable
{
    Session("session"),
    Event("event"),
    UserFeedback("user_report"),
    Attachment("attachment"),
    Transaction("transaction"),
    Profile("profile"),
    ProfileChunk("profile_chunk"),
    ClientReport("client_report"),
    ReplayEvent("replay_event"),
    ReplayRecording("replay_recording"),
    ReplayVideo("replay_video"),
    CheckIn("check_in"),
    Feedback("feedback"),
    Log("log"),
    Unknown("__unknown__");

    private final String itemType;

    public static SentryItemType resolve(Object item2) {
        if (item2 instanceof SentryEvent) {
            return ((SentryEvent)item2).getContexts().getFeedback() == null ? Event : Feedback;
        }
        if (item2 instanceof SentryTransaction) {
            return Transaction;
        }
        if (item2 instanceof Session) {
            return Session;
        }
        if (item2 instanceof ClientReport) {
            return ClientReport;
        }
        return Attachment;
    }

    private SentryItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getItemType() {
        return this.itemType;
    }

    @NotNull
    public static SentryItemType valueOfLabel(String itemType) {
        for (SentryItemType sentryItemType : SentryItemType.values()) {
            if (!sentryItemType.itemType.equals(itemType)) continue;
            return sentryItemType;
        }
        return Unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.value(this.itemType);
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryItemType> {
        @Override
        @NotNull
        public SentryItemType deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            return SentryItemType.valueOfLabel(reader2.nextString().toLowerCase(Locale.ROOT));
        }
    }
}

