/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.DateUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryDate;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLogEventAttributeValue;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLogLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryLogEvent
implements JsonUnknown,
JsonSerializable {
    @NotNull
    private SentryId traceId;
    @NotNull
    private Double timestamp;
    @NotNull
    private String body;
    @NotNull
    private SentryLogLevel level;
    @Nullable
    private Integer severityNumber;
    @Nullable
    private Map<String, SentryLogEventAttributeValue> attributes;
    @Nullable
    private Map<String, Object> unknown;

    public SentryLogEvent(@NotNull SentryId traceId, @NotNull SentryDate timestamp2, @NotNull String body2, @NotNull SentryLogLevel level) {
        this(traceId, DateUtils.nanosToSeconds(timestamp2.nanoTimestamp()), body2, level);
    }

    public SentryLogEvent(@NotNull SentryId traceId, @NotNull Double timestamp2, @NotNull String body2, @NotNull SentryLogLevel level) {
        this.traceId = traceId;
        this.timestamp = timestamp2;
        this.body = body2;
        this.level = level;
    }

    @NotNull
    public Double getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(@NotNull Double timestamp2) {
        this.timestamp = timestamp2;
    }

    @NotNull
    public String getBody() {
        return this.body;
    }

    public void setBody(@NotNull String body2) {
        this.body = body2;
    }

    @NotNull
    public SentryLogLevel getLevel() {
        return this.level;
    }

    public void setLevel(@NotNull SentryLogLevel level) {
        this.level = level;
    }

    @Nullable
    public Map<String, SentryLogEventAttributeValue> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(@Nullable Map<String, SentryLogEventAttributeValue> attributes) {
        this.attributes = attributes;
    }

    @Nullable
    public Integer getSeverityNumber() {
        return this.severityNumber;
    }

    public void setSeverityNumber(@Nullable Integer severityNumber) {
        this.severityNumber = severityNumber;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        writer2.name("timestamp").value(logger, DateUtils.doubleToBigDecimal(this.timestamp));
        writer2.name("trace_id").value(logger, this.traceId);
        writer2.name("body").value(this.body);
        writer2.name("level").value(logger, this.level);
        if (this.severityNumber != null) {
            writer2.name("severity_number").value(logger, this.severityNumber);
        }
        if (this.attributes != null) {
            writer2.name("attributes").value(logger, this.attributes);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key).value(logger, value2);
            }
        }
        writer2.endObject();
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class JsonKeys {
        public static final String TIMESTAMP = "timestamp";
        public static final String TRACE_ID = "trace_id";
        public static final String LEVEL = "level";
        public static final String SEVERITY_NUMBER = "severity_number";
        public static final String BODY = "body";
        public static final String ATTRIBUTES = "attributes";
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryLogEvent> {
        @Override
        @NotNull
        public SentryLogEvent deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            IllegalStateException exception;
            String message2;
            @Nullable HashMap<String, Object> unknown = null;
            SentryId traceId = null;
            Double timestamp2 = null;
            String body2 = null;
            SentryLogLevel level = null;
            Integer severityNumber = null;
            Map<String, SentryLogEventAttributeValue> attributes = null;
            reader2.beginObject();
            block16: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "trace_id": {
                        traceId = reader2.nextOrNull(logger, new SentryId.Deserializer());
                        continue block16;
                    }
                    case "timestamp": {
                        timestamp2 = reader2.nextDoubleOrNull();
                        continue block16;
                    }
                    case "body": {
                        body2 = reader2.nextStringOrNull();
                        continue block16;
                    }
                    case "level": {
                        level = reader2.nextOrNull(logger, new SentryLogLevel.Deserializer());
                        continue block16;
                    }
                    case "severity_number": {
                        severityNumber = reader2.nextIntegerOrNull();
                        continue block16;
                    }
                    case "attributes": {
                        attributes = reader2.nextMapOrNull(logger, new SentryLogEventAttributeValue.Deserializer());
                        continue block16;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            reader2.endObject();
            if (traceId == null) {
                message2 = "Missing required field \"trace_id\"";
                exception = new IllegalStateException(message2);
                logger.log(SentryLevel.ERROR, message2, exception);
                throw exception;
            }
            if (timestamp2 == null) {
                message2 = "Missing required field \"timestamp\"";
                exception = new IllegalStateException(message2);
                logger.log(SentryLevel.ERROR, message2, exception);
                throw exception;
            }
            if (body2 == null) {
                message2 = "Missing required field \"body\"";
                exception = new IllegalStateException(message2);
                logger.log(SentryLevel.ERROR, message2, exception);
                throw exception;
            }
            if (level == null) {
                message2 = "Missing required field \"level\"";
                exception = new IllegalStateException(message2);
                logger.log(SentryLevel.ERROR, message2, exception);
                throw exception;
            }
            SentryLogEvent logEvent = new SentryLogEvent(traceId, timestamp2, body2, level);
            logEvent.setAttributes(attributes);
            logEvent.setSeverityNumber(severityNumber);
            logEvent.setUnknown(unknown);
            return logEvent;
        }
    }
}

