/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.EventProcessor;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Hint;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryBaseEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryRuntime;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryTransaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SentryRuntimeEventProcessor
implements EventProcessor {
    @Nullable
    private final String javaVersion;
    @Nullable
    private final String javaVendor;

    public SentryRuntimeEventProcessor(@Nullable String javaVersion, @Nullable String javaVendor) {
        this.javaVersion = javaVersion;
        this.javaVendor = javaVendor;
    }

    public SentryRuntimeEventProcessor() {
        this(System.getProperty("java.version"), System.getProperty("java.vendor"));
    }

    @Override
    @NotNull
    public SentryEvent process(@NotNull SentryEvent event2, @Nullable Hint hint) {
        return this.process(event2);
    }

    @Override
    @NotNull
    public SentryTransaction process(@NotNull SentryTransaction transaction, @Nullable Hint hint) {
        return this.process(transaction);
    }

    @NotNull
    private <T extends SentryBaseEvent> T process(@NotNull T event2) {
        SentryRuntime runtime;
        if (event2.getContexts().getRuntime() == null) {
            event2.getContexts().setRuntime(new SentryRuntime());
        }
        if ((runtime = event2.getContexts().getRuntime()) != null && runtime.getName() == null && runtime.getVersion() == null) {
            runtime.setName(this.javaVendor);
            runtime.setVersion(this.javaVersion);
        }
        return event2;
    }

    @Override
    @Nullable
    public Long getOrder() {
        return 2000L;
    }
}

