/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryStackTraceFactory;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryStackFrame;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryStackTrace;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryThread;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class SentryThreadFactory {
    @NotNull
    private final SentryStackTraceFactory sentryStackTraceFactory;
    @NotNull
    private final SentryOptions options;

    public SentryThreadFactory(@NotNull SentryStackTraceFactory sentryStackTraceFactory, @NotNull SentryOptions options2) {
        this.sentryStackTraceFactory = Objects.requireNonNull(sentryStackTraceFactory, "The SentryStackTraceFactory is required.");
        this.options = Objects.requireNonNull(options2, "The SentryOptions is required");
    }

    @Nullable
    List<SentryThread> getCurrentThread() {
        HashMap<Thread, StackTraceElement[]> threads = new HashMap<Thread, StackTraceElement[]>();
        Thread currentThread = Thread.currentThread();
        threads.put(currentThread, currentThread.getStackTrace());
        return this.getCurrentThreads(threads, null, false);
    }

    @Nullable
    List<SentryThread> getCurrentThreads(@Nullable List<Long> mechanismThreadIds, boolean ignoreCurrentThread) {
        return this.getCurrentThreads(Thread.getAllStackTraces(), mechanismThreadIds, ignoreCurrentThread);
    }

    @Nullable
    List<SentryThread> getCurrentThreads(@Nullable List<Long> mechanismThreadIds) {
        return this.getCurrentThreads(Thread.getAllStackTraces(), mechanismThreadIds, false);
    }

    @TestOnly
    @Nullable
    List<SentryThread> getCurrentThreads(@NotNull Map<Thread, StackTraceElement[]> threads, @Nullable List<Long> mechanismThreadIds, boolean ignoreCurrentThread) {
        ArrayList<SentryThread> result2 = null;
        Thread currentThread = Thread.currentThread();
        if (!threads.isEmpty()) {
            result2 = new ArrayList<SentryThread>();
            if (!threads.containsKey(currentThread)) {
                threads.put(currentThread, currentThread.getStackTrace());
            }
            for (Map.Entry<Thread, StackTraceElement[]> item2 : threads.entrySet()) {
                Thread thread = item2.getKey();
                boolean crashed = thread == currentThread && !ignoreCurrentThread || mechanismThreadIds != null && mechanismThreadIds.contains(thread.getId()) && !ignoreCurrentThread;
                result2.add(this.getSentryThread(crashed, item2.getValue(), item2.getKey()));
            }
        }
        return result2;
    }

    @NotNull
    private SentryThread getSentryThread(boolean crashed, @NotNull StackTraceElement[] stackFramesElements, @NotNull Thread thread) {
        SentryThread sentryThread = new SentryThread();
        sentryThread.setName(thread.getName());
        sentryThread.setPriority(thread.getPriority());
        sentryThread.setId(thread.getId());
        sentryThread.setDaemon(thread.isDaemon());
        sentryThread.setState(thread.getState().name());
        sentryThread.setCrashed(crashed);
        List<SentryStackFrame> frames = this.sentryStackTraceFactory.getStackFrames(stackFramesElements, false);
        if (this.options.isAttachStacktrace() && frames != null && !frames.isEmpty()) {
            SentryStackTrace sentryStackTrace = new SentryStackTrace(frames);
            sentryStackTrace.setSnapshot(true);
            sentryThread.setStacktrace(sentryStackTrace);
        }
        return sentryThread;
    }
}

