/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.DateUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISentryLifecycleToken;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryUUID;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.User;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.AutoClosableReentrantLock;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.StringUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Session
implements JsonUnknown,
JsonSerializable {
    @NotNull
    private final Date started;
    @Nullable
    private Date timestamp;
    @NotNull
    private final AtomicInteger errorCount;
    @Nullable
    private final String distinctId;
    @Nullable
    private final String sessionId;
    @Nullable
    private Boolean init;
    @NotNull
    private State status;
    @Nullable
    private Long sequence;
    @Nullable
    private Double duration;
    @Nullable
    private final String ipAddress;
    @Nullable
    private String userAgent;
    @Nullable
    private final String environment;
    @NotNull
    private final String release;
    @Nullable
    private String abnormalMechanism;
    @NotNull
    private final AutoClosableReentrantLock sessionLock = new AutoClosableReentrantLock();
    @Nullable
    private Map<String, Object> unknown;

    public Session(@NotNull State status2, @NotNull Date started, @Nullable Date timestamp2, int errorCount, @Nullable String distinctId, @Nullable String sessionId, @Nullable Boolean init, @Nullable Long sequence2, @Nullable Double duration, @Nullable String ipAddress, @Nullable String userAgent, @Nullable String environment, @NotNull String release, @Nullable String abnormalMechanism) {
        this.status = status2;
        this.started = started;
        this.timestamp = timestamp2;
        this.errorCount = new AtomicInteger(errorCount);
        this.distinctId = distinctId;
        this.sessionId = sessionId;
        this.init = init;
        this.sequence = sequence2;
        this.duration = duration;
        this.ipAddress = ipAddress;
        this.userAgent = userAgent;
        this.environment = environment;
        this.release = release;
        this.abnormalMechanism = abnormalMechanism;
    }

    public Session(@Nullable String distinctId, @Nullable User user2, @Nullable String environment, @NotNull String release) {
        this(State.Ok, DateUtils.getCurrentDateTime(), DateUtils.getCurrentDateTime(), 0, distinctId, SentryUUID.generateSentryId(), true, null, null, user2 != null ? user2.getIpAddress() : null, null, environment, release, null);
    }

    public boolean isTerminated() {
        return this.status != State.Ok;
    }

    @Nullable
    public Date getStarted() {
        if (this.started == null) {
            return null;
        }
        return (Date)this.started.clone();
    }

    @Nullable
    public String getDistinctId() {
        return this.distinctId;
    }

    @Nullable
    public String getSessionId() {
        return this.sessionId;
    }

    @Nullable
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Nullable
    public String getUserAgent() {
        return this.userAgent;
    }

    @Nullable
    public String getEnvironment() {
        return this.environment;
    }

    @NotNull
    public String getRelease() {
        return this.release;
    }

    @Nullable
    public Boolean getInit() {
        return this.init;
    }

    @ApiStatus.Internal
    public void setInitAsTrue() {
        this.init = true;
    }

    public int errorCount() {
        return this.errorCount.get();
    }

    @NotNull
    public State getStatus() {
        return this.status;
    }

    @Nullable
    public Long getSequence() {
        return this.sequence;
    }

    @Nullable
    public Double getDuration() {
        return this.duration;
    }

    @Nullable
    public String getAbnormalMechanism() {
        return this.abnormalMechanism;
    }

    @Nullable
    public Date getTimestamp() {
        Date timestampRef = this.timestamp;
        return timestampRef != null ? (Date)timestampRef.clone() : null;
    }

    public void end() {
        this.end(DateUtils.getCurrentDateTime());
    }

    public void end(@Nullable Date timestamp2) {
        try (@NotNull ISentryLifecycleToken ignored = this.sessionLock.acquire();){
            this.init = null;
            if (this.status == State.Ok) {
                this.status = State.Exited;
            }
            this.timestamp = timestamp2 != null ? timestamp2 : DateUtils.getCurrentDateTime();
            if (this.timestamp != null) {
                this.duration = this.calculateDurationTime(this.timestamp);
                this.sequence = this.getSequenceTimestamp(this.timestamp);
            }
        }
    }

    private double calculateDurationTime(@NotNull Date timestamp2) {
        long diff = Math.abs(timestamp2.getTime() - this.started.getTime());
        return (double)diff / 1000.0;
    }

    public boolean update(@Nullable State status2, @Nullable String userAgent, boolean addErrorsCount) {
        return this.update(status2, userAgent, addErrorsCount, null);
    }

    public boolean update(@Nullable State status2, @Nullable String userAgent, boolean addErrorsCount, @Nullable String abnormalMechanism) {
        try (@NotNull ISentryLifecycleToken ignored = this.sessionLock.acquire();){
            boolean sessionHasBeenUpdated = false;
            if (status2 != null) {
                this.status = status2;
                sessionHasBeenUpdated = true;
            }
            if (userAgent != null) {
                this.userAgent = userAgent;
                sessionHasBeenUpdated = true;
            }
            if (addErrorsCount) {
                this.errorCount.addAndGet(1);
                sessionHasBeenUpdated = true;
            }
            if (abnormalMechanism != null) {
                this.abnormalMechanism = abnormalMechanism;
                sessionHasBeenUpdated = true;
            }
            if (sessionHasBeenUpdated) {
                this.init = null;
                this.timestamp = DateUtils.getCurrentDateTime();
                if (this.timestamp != null) {
                    this.sequence = this.getSequenceTimestamp(this.timestamp);
                }
            }
            boolean bl = sessionHasBeenUpdated;
            return bl;
        }
    }

    private long getSequenceTimestamp(@NotNull Date timestamp2) {
        long sequence2 = timestamp2.getTime();
        if (sequence2 < 0L) {
            sequence2 = Math.abs(sequence2);
        }
        return sequence2;
    }

    @NotNull
    public Session clone() {
        return new Session(this.status, this.started, this.timestamp, this.errorCount.get(), this.distinctId, this.sessionId, this.init, this.sequence, this.duration, this.ipAddress, this.userAgent, this.environment, this.release, this.abnormalMechanism);
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        if (this.sessionId != null) {
            writer2.name("sid").value(this.sessionId);
        }
        if (this.distinctId != null) {
            writer2.name("did").value(this.distinctId);
        }
        if (this.init != null) {
            writer2.name("init").value(this.init);
        }
        writer2.name("started").value(logger, this.started);
        writer2.name("status").value(logger, this.status.name().toLowerCase(Locale.ROOT));
        if (this.sequence != null) {
            writer2.name("seq").value(this.sequence);
        }
        writer2.name("errors").value(this.errorCount.intValue());
        if (this.duration != null) {
            writer2.name("duration").value(this.duration);
        }
        if (this.timestamp != null) {
            writer2.name("timestamp").value(logger, this.timestamp);
        }
        if (this.abnormalMechanism != null) {
            writer2.name("abnormal_mechanism").value(logger, this.abnormalMechanism);
        }
        writer2.name("attrs");
        writer2.beginObject();
        writer2.name("release").value(logger, this.release);
        if (this.environment != null) {
            writer2.name("environment").value(logger, this.environment);
        }
        if (this.ipAddress != null) {
            writer2.name("ip_address").value(logger, this.ipAddress);
        }
        if (this.userAgent != null) {
            writer2.name("user_agent").value(logger, this.userAgent);
        }
        writer2.endObject();
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static enum State {
        Ok,
        Exited,
        Crashed,
        Abnormal;

    }

    public static final class JsonKeys {
        public static final String SID = "sid";
        public static final String DID = "did";
        public static final String INIT = "init";
        public static final String STARTED = "started";
        public static final String STATUS = "status";
        public static final String SEQ = "seq";
        public static final String ERRORS = "errors";
        public static final String DURATION = "duration";
        public static final String TIMESTAMP = "timestamp";
        public static final String ATTRS = "attrs";
        public static final String RELEASE = "release";
        public static final String ENVIRONMENT = "environment";
        public static final String IP_ADDRESS = "ip_address";
        public static final String USER_AGENT = "user_agent";
        public static final String ABNORMAL_MECHANISM = "abnormal_mechanism";
    }

    public static final class Deserializer
    implements JsonDeserializer<Session> {
        @Override
        @NotNull
        public Session deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            reader2.beginObject();
            Date started = null;
            Date timestamp2 = null;
            Integer errorCount = null;
            String distinctId = null;
            String sessionId = null;
            Boolean init = null;
            State status2 = null;
            Long sequence2 = null;
            Double duration = null;
            String ipAddress = null;
            String userAgent = null;
            String environment = null;
            String release = null;
            String abnormalMechanism = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block38: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "sid": {
                        String sid = reader2.nextStringOrNull();
                        if (sid != null && (sid.length() == 36 || sid.length() == 32)) {
                            sessionId = sid;
                            continue block38;
                        }
                        logger.log(SentryLevel.ERROR, "%s sid is not valid.", sid);
                        continue block38;
                    }
                    case "did": {
                        distinctId = reader2.nextStringOrNull();
                        continue block38;
                    }
                    case "init": {
                        init = reader2.nextBooleanOrNull();
                        continue block38;
                    }
                    case "started": {
                        started = reader2.nextDateOrNull(logger);
                        continue block38;
                    }
                    case "status": {
                        String statusValue = StringUtils.capitalize(reader2.nextStringOrNull());
                        if (statusValue == null) continue block38;
                        status2 = State.valueOf(statusValue);
                        continue block38;
                    }
                    case "seq": {
                        sequence2 = reader2.nextLongOrNull();
                        continue block38;
                    }
                    case "errors": {
                        errorCount = reader2.nextIntegerOrNull();
                        continue block38;
                    }
                    case "duration": {
                        duration = reader2.nextDoubleOrNull();
                        continue block38;
                    }
                    case "timestamp": {
                        timestamp2 = reader2.nextDateOrNull(logger);
                        continue block38;
                    }
                    case "abnormal_mechanism": {
                        abnormalMechanism = reader2.nextStringOrNull();
                        continue block38;
                    }
                    case "attrs": {
                        reader2.beginObject();
                        block39: while (reader2.peek() == JsonToken.NAME) {
                            String nextAttrName;
                            switch (nextAttrName = reader2.nextName()) {
                                case "release": {
                                    release = reader2.nextStringOrNull();
                                    continue block39;
                                }
                                case "environment": {
                                    environment = reader2.nextStringOrNull();
                                    continue block39;
                                }
                                case "ip_address": {
                                    ipAddress = reader2.nextStringOrNull();
                                    continue block39;
                                }
                                case "user_agent": {
                                    userAgent = reader2.nextStringOrNull();
                                    continue block39;
                                }
                            }
                            reader2.skipValue();
                        }
                        reader2.endObject();
                        continue block38;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            if (status2 == null) {
                throw this.missingRequiredFieldException("status", logger);
            }
            if (started == null) {
                throw this.missingRequiredFieldException("started", logger);
            }
            if (errorCount == null) {
                throw this.missingRequiredFieldException("errors", logger);
            }
            if (release == null) {
                throw this.missingRequiredFieldException("release", logger);
            }
            Session session = new Session(status2, started, timestamp2, errorCount, distinctId, sessionId, init, sequence2, duration, ipAddress, userAgent, environment, release, abnormalMechanism);
            session.setUnknown(unknown);
            reader2.endObject();
            return session;
        }

        private Exception missingRequiredFieldException(String field2, ILogger logger) {
            String message2 = "Missing required field \"" + field2 + "\"";
            IllegalStateException exception = new IllegalStateException(message2);
            logger.log(SentryLevel.ERROR, message2, exception);
            return exception;
        }
    }
}

