/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.BaggageHeader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.IScopes;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISentryLifecycleToken;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISpan;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Instrumenter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.MeasurementUnit;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.NoOpScopesLifecycleToken;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.NoOpSpan;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryDate;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryTraceHeader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryTracer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanContext;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanFinishedCallback;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanStatus;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.TraceContext;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.TracesSamplingDecision;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.TransactionContext;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Contexts;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.MeasurementValue;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class Span
implements ISpan {
    @NotNull
    private SentryDate startTimestamp;
    @Nullable
    private SentryDate timestamp;
    @NotNull
    private final SpanContext context;
    @NotNull
    private final SentryTracer transaction;
    @Nullable
    private Throwable throwable;
    @NotNull
    private final IScopes scopes;
    private boolean finished = false;
    @NotNull
    private final AtomicBoolean isFinishing = new AtomicBoolean(false);
    @NotNull
    private final SpanOptions options;
    @Nullable
    private SpanFinishedCallback spanFinishedCallback;
    @NotNull
    private final Map<String, Object> data = new ConcurrentHashMap<String, Object>();
    @NotNull
    private final Map<String, MeasurementValue> measurements = new ConcurrentHashMap<String, MeasurementValue>();
    @NotNull
    private final Contexts contexts = new Contexts();

    Span(@NotNull SentryTracer transaction, @NotNull IScopes scopes, @NotNull SpanContext spanContext, @NotNull SpanOptions options2, @Nullable SpanFinishedCallback spanFinishedCallback) {
        this.context = spanContext;
        this.context.setOrigin(options2.getOrigin());
        this.transaction = Objects.requireNonNull(transaction, "transaction is required");
        this.scopes = Objects.requireNonNull(scopes, "Scopes are required");
        this.options = options2;
        this.spanFinishedCallback = spanFinishedCallback;
        @Nullable SentryDate startTimestamp = options2.getStartTimestamp();
        this.startTimestamp = startTimestamp != null ? startTimestamp : scopes.getOptions().getDateProvider().now();
    }

    public Span(@NotNull TransactionContext context, @NotNull SentryTracer sentryTracer, @NotNull IScopes scopes, @NotNull SpanOptions options2) {
        this.context = Objects.requireNonNull(context, "context is required");
        this.context.setOrigin(options2.getOrigin());
        this.transaction = Objects.requireNonNull(sentryTracer, "sentryTracer is required");
        this.scopes = Objects.requireNonNull(scopes, "scopes are required");
        this.spanFinishedCallback = null;
        @Nullable SentryDate startTimestamp = options2.getStartTimestamp();
        this.startTimestamp = startTimestamp != null ? startTimestamp : scopes.getOptions().getDateProvider().now();
        this.options = options2;
    }

    @Override
    @NotNull
    public SentryDate getStartDate() {
        return this.startTimestamp;
    }

    @Override
    @Nullable
    public SentryDate getFinishDate() {
        return this.timestamp;
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation) {
        return this.startChild(operation, (String)null);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description2, @Nullable SentryDate timestamp2, @NotNull Instrumenter instrumenter, @NotNull SpanOptions spanOptions) {
        if (this.finished) {
            return NoOpSpan.getInstance();
        }
        return this.transaction.startChild(this.context.getSpanId(), operation, description2, timestamp2, instrumenter, spanOptions);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description2) {
        if (this.finished) {
            return NoOpSpan.getInstance();
        }
        return this.transaction.startChild(this.context.getSpanId(), operation, description2);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description2, @NotNull SpanOptions spanOptions) {
        if (this.finished) {
            return NoOpSpan.getInstance();
        }
        return this.transaction.startChild(this.context.getSpanId(), operation, description2, spanOptions);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull SpanContext spanContext, @NotNull SpanOptions spanOptions) {
        return this.transaction.startChild(spanContext, spanOptions);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description2, @Nullable SentryDate timestamp2, @NotNull Instrumenter instrumenter) {
        return this.startChild(operation, description2, timestamp2, instrumenter, new SpanOptions());
    }

    @Override
    @NotNull
    public SentryTraceHeader toSentryTrace() {
        return new SentryTraceHeader(this.context.getTraceId(), this.context.getSpanId(), this.context.getSampled());
    }

    @Override
    @Nullable
    public TraceContext traceContext() {
        return this.transaction.traceContext();
    }

    @Override
    @Nullable
    public BaggageHeader toBaggageHeader(@Nullable List<String> thirdPartyBaggageHeaders) {
        return this.transaction.toBaggageHeader(thirdPartyBaggageHeaders);
    }

    @Override
    public void finish() {
        this.finish(this.context.getStatus());
    }

    @Override
    public void finish(@Nullable SpanStatus status2) {
        this.finish(status2, this.scopes.getOptions().getDateProvider().now());
    }

    @Override
    public void finish(@Nullable SpanStatus status2, @Nullable SentryDate timestamp2) {
        if (this.finished || !this.isFinishing.compareAndSet(false, true)) {
            return;
        }
        this.context.setStatus(status2);
        SentryDate sentryDate = this.timestamp = timestamp2 == null ? this.scopes.getOptions().getDateProvider().now() : timestamp2;
        if (this.options.isTrimStart() || this.options.isTrimEnd()) {
            @Nullable SentryDate minChildStart = null;
            SentryDate maxChildEnd = null;
            @NotNull List<Span> children = this.transaction.getRoot().getSpanId().equals(this.getSpanId()) ? this.transaction.getChildren() : this.getDirectChildren();
            for (Span child : children) {
                if (minChildStart == null || child.getStartDate().isBefore(minChildStart)) {
                    minChildStart = child.getStartDate();
                }
                if (maxChildEnd != null && (child.getFinishDate() == null || !child.getFinishDate().isAfter(maxChildEnd))) continue;
                maxChildEnd = child.getFinishDate();
            }
            if (this.options.isTrimStart() && minChildStart != null && this.startTimestamp.isBefore(minChildStart)) {
                this.updateStartDate(minChildStart);
            }
            if (this.options.isTrimEnd() && maxChildEnd != null && (this.timestamp == null || this.timestamp.isAfter(maxChildEnd))) {
                this.updateEndDate(maxChildEnd);
            }
        }
        if (this.throwable != null) {
            this.scopes.setSpanContext(this.throwable, this, this.transaction.getName());
        }
        if (this.spanFinishedCallback != null) {
            this.spanFinishedCallback.execute(this);
        }
        this.finished = true;
    }

    @Override
    public void setOperation(@NotNull String operation) {
        this.context.setOperation(operation);
    }

    @Override
    @NotNull
    public String getOperation() {
        return this.context.getOperation();
    }

    @Override
    public void setDescription(@Nullable String description2) {
        this.context.setDescription(description2);
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.context.getDescription();
    }

    @Override
    public void setStatus(@Nullable SpanStatus status2) {
        this.context.setStatus(status2);
    }

    @Override
    @Nullable
    public SpanStatus getStatus() {
        return this.context.getStatus();
    }

    @Override
    @NotNull
    public SpanContext getSpanContext() {
        return this.context;
    }

    @Override
    public void setTag(@Nullable String key, @Nullable String value2) {
        this.context.setTag(key, value2);
    }

    @Override
    @Nullable
    public String getTag(@Nullable String key) {
        if (key == null) {
            return null;
        }
        return this.context.getTags().get(key);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @NotNull
    public Map<String, Object> getData() {
        return this.data;
    }

    @Override
    @Nullable
    public Boolean isSampled() {
        return this.context.getSampled();
    }

    @Nullable
    public Boolean isProfileSampled() {
        return this.context.getProfileSampled();
    }

    @Override
    @Nullable
    public TracesSamplingDecision getSamplingDecision() {
        return this.context.getSamplingDecision();
    }

    @Override
    public void setThrowable(@Nullable Throwable throwable) {
        this.throwable = throwable;
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        return this.throwable;
    }

    @NotNull
    public SentryId getTraceId() {
        return this.context.getTraceId();
    }

    @NotNull
    public SpanId getSpanId() {
        return this.context.getSpanId();
    }

    @Nullable
    public SpanId getParentSpanId() {
        return this.context.getParentSpanId();
    }

    public Map<String, String> getTags() {
        return this.context.getTags();
    }

    @Override
    public void setData(@Nullable String key, @Nullable Object value2) {
        if (key == null) {
            return;
        }
        if (value2 == null) {
            this.data.remove(key);
        } else {
            this.data.put(key, value2);
        }
    }

    @Override
    @Nullable
    public Object getData(@Nullable String key) {
        if (key == null) {
            return null;
        }
        return this.data.get(key);
    }

    @Override
    public void setMeasurement(@NotNull String name2, @NotNull Number value2) {
        if (this.isFinished()) {
            this.scopes.getOptions().getLogger().log(SentryLevel.DEBUG, "The span is already finished. Measurement %s cannot be set", name2);
            return;
        }
        this.measurements.put(name2, new MeasurementValue(value2, null));
        if (this.transaction.getRoot() != this) {
            this.transaction.setMeasurementFromChild(name2, value2);
        }
    }

    @Override
    public void setMeasurement(@NotNull String name2, @NotNull Number value2, @NotNull MeasurementUnit unit) {
        if (this.isFinished()) {
            this.scopes.getOptions().getLogger().log(SentryLevel.DEBUG, "The span is already finished. Measurement %s cannot be set", name2);
            return;
        }
        this.measurements.put(name2, new MeasurementValue(value2, unit.apiName()));
        if (this.transaction.getRoot() != this) {
            this.transaction.setMeasurementFromChild(name2, value2, unit);
        }
    }

    @NotNull
    public Map<String, MeasurementValue> getMeasurements() {
        return this.measurements;
    }

    @Override
    public boolean updateEndDate(@NotNull SentryDate date) {
        if (this.timestamp != null) {
            this.timestamp = date;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNoOp() {
        return false;
    }

    @Override
    public void setContext(@Nullable String key, @Nullable Object context) {
        this.contexts.put(key, context);
    }

    @Override
    @NotNull
    public Contexts getContexts() {
        return this.contexts;
    }

    void setSpanFinishedCallback(@Nullable SpanFinishedCallback callback) {
        this.spanFinishedCallback = callback;
    }

    @Nullable
    SpanFinishedCallback getSpanFinishedCallback() {
        return this.spanFinishedCallback;
    }

    private void updateStartDate(@NotNull SentryDate date) {
        this.startTimestamp = date;
    }

    @NotNull
    SpanOptions getOptions() {
        return this.options;
    }

    @NotNull
    private List<Span> getDirectChildren() {
        ArrayList<Span> children = new ArrayList<Span>();
        for (Span span : this.transaction.getSpans()) {
            if (span.getParentSpanId() == null || !span.getParentSpanId().equals(this.getSpanId())) continue;
            children.add(span);
        }
        return children;
    }

    @Override
    @NotNull
    public ISentryLifecycleToken makeCurrent() {
        return NoOpScopesLifecycleToken.getInstance();
    }
}

