/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import java.io.IOException;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SpanStatus implements JsonSerializable
{
    OK(0, 399),
    CANCELLED(499),
    INTERNAL_ERROR(500),
    UNKNOWN(500),
    UNKNOWN_ERROR(500),
    INVALID_ARGUMENT(400),
    DEADLINE_EXCEEDED(504),
    NOT_FOUND(404),
    ALREADY_EXISTS(409),
    PERMISSION_DENIED(403),
    RESOURCE_EXHAUSTED(429),
    FAILED_PRECONDITION(400),
    ABORTED(409),
    OUT_OF_RANGE(400),
    UNIMPLEMENTED(501),
    UNAVAILABLE(503),
    DATA_LOSS(500),
    UNAUTHENTICATED(401);

    private final int minHttpStatusCode;
    private final int maxHttpStatusCode;

    private SpanStatus(int httpStatusCode) {
        this.minHttpStatusCode = httpStatusCode;
        this.maxHttpStatusCode = httpStatusCode;
    }

    private SpanStatus(int minHttpStatusCode, int maxHttpStatusCode) {
        this.minHttpStatusCode = minHttpStatusCode;
        this.maxHttpStatusCode = maxHttpStatusCode;
    }

    @Nullable
    public static SpanStatus fromHttpStatusCode(int httpStatusCode) {
        for (SpanStatus status2 : SpanStatus.values()) {
            if (!status2.matches(httpStatusCode)) continue;
            return status2;
        }
        return null;
    }

    @NotNull
    public static SpanStatus fromHttpStatusCode(@Nullable Integer httpStatusCode, @NotNull SpanStatus defaultStatus) {
        SpanStatus spanStatus = httpStatusCode != null ? SpanStatus.fromHttpStatusCode(httpStatusCode) : defaultStatus;
        return spanStatus != null ? spanStatus : defaultStatus;
    }

    private boolean matches(int httpStatusCode) {
        return httpStatusCode >= this.minHttpStatusCode && httpStatusCode <= this.maxHttpStatusCode;
    }

    @NotNull
    public String apiName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Nullable
    public static SpanStatus fromApiNameSafely(@Nullable String apiName) {
        if (apiName == null) {
            return null;
        }
        try {
            return SpanStatus.valueOf(apiName.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.value(this.apiName());
    }

    public static final class Deserializer
    implements JsonDeserializer<SpanStatus> {
        @Override
        @NotNull
        public SpanStatus deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            return SpanStatus.valueOf(reader2.nextString().toUpperCase(Locale.ROOT));
        }
    }
}

