/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Hint;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.IScopes;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ITransaction;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Integration;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.UncaughtExceptionHandler;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.exception.ExceptionMechanismException;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.hints.BlockingFlushHint;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.hints.EventDropReason;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.hints.SessionEnd;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.hints.TransactionEnd;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Mechanism;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.HintUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.IntegrationUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class UncaughtExceptionHandlerIntegration
implements Integration,
Thread.UncaughtExceptionHandler,
Closeable {
    @Nullable
    private Thread.UncaughtExceptionHandler defaultExceptionHandler;
    @Nullable
    private IScopes scopes;
    @Nullable
    private SentryOptions options;
    private boolean registered = false;
    @NotNull
    private final UncaughtExceptionHandler threadAdapter;

    public UncaughtExceptionHandlerIntegration() {
        this(UncaughtExceptionHandler.Adapter.getInstance());
    }

    UncaughtExceptionHandlerIntegration(@NotNull UncaughtExceptionHandler threadAdapter) {
        this.threadAdapter = Objects.requireNonNull(threadAdapter, "threadAdapter is required.");
    }

    @Override
    public final void register(@NotNull IScopes scopes, @NotNull SentryOptions options2) {
        if (this.registered) {
            options2.getLogger().log(SentryLevel.ERROR, "Attempt to register a UncaughtExceptionHandlerIntegration twice.", new Object[0]);
            return;
        }
        this.registered = true;
        this.scopes = Objects.requireNonNull(scopes, "Scopes are required");
        this.options = Objects.requireNonNull(options2, "SentryOptions is required");
        this.options.getLogger().log(SentryLevel.DEBUG, "UncaughtExceptionHandlerIntegration enabled: %s", this.options.isEnableUncaughtExceptionHandler());
        if (this.options.isEnableUncaughtExceptionHandler()) {
            Thread.UncaughtExceptionHandler currentHandler = this.threadAdapter.getDefaultUncaughtExceptionHandler();
            if (currentHandler != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "default UncaughtExceptionHandler class='" + currentHandler.getClass().getName() + "'", new Object[0]);
                if (currentHandler instanceof UncaughtExceptionHandlerIntegration) {
                    UncaughtExceptionHandlerIntegration currentHandlerIntegration = (UncaughtExceptionHandlerIntegration)currentHandler;
                    this.defaultExceptionHandler = currentHandlerIntegration.defaultExceptionHandler;
                } else {
                    this.defaultExceptionHandler = currentHandler;
                }
            }
            this.threadAdapter.setDefaultUncaughtExceptionHandler(this);
            this.options.getLogger().log(SentryLevel.DEBUG, "UncaughtExceptionHandlerIntegration installed.", new Object[0]);
            IntegrationUtils.addIntegrationToSdkVersion("UncaughtExceptionHandler");
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable thrown) {
        if (this.options != null && this.scopes != null) {
            this.options.getLogger().log(SentryLevel.INFO, "Uncaught exception received.", new Object[0]);
            try {
                UncaughtExceptionHint exceptionHint = new UncaughtExceptionHint(this.options.getFlushTimeoutMillis(), this.options.getLogger());
                Throwable throwable = UncaughtExceptionHandlerIntegration.getUnhandledThrowable(thread, thrown);
                SentryEvent event2 = new SentryEvent(throwable);
                event2.setLevel(SentryLevel.FATAL);
                ITransaction transaction = this.scopes.getTransaction();
                if (transaction == null && event2.getEventId() != null) {
                    exceptionHint.setFlushable(event2.getEventId());
                }
                Hint hint = HintUtils.createWithTypeCheckHint(exceptionHint);
                @NotNull SentryId sentryId2 = this.scopes.captureEvent(event2, hint);
                boolean isEventDropped = sentryId2.equals(SentryId.EMPTY_ID);
                EventDropReason eventDropReason = HintUtils.getEventDropReason(hint);
                if (!(isEventDropped && !EventDropReason.MULTITHREADED_DEDUPLICATION.equals((Object)eventDropReason) || exceptionHint.waitFlush())) {
                    this.options.getLogger().log(SentryLevel.WARNING, "Timed out waiting to flush event to disk before crashing. Event: %s", event2.getEventId());
                }
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error sending uncaught exception to Sentry.", e);
            }
            if (this.defaultExceptionHandler != null) {
                this.options.getLogger().log(SentryLevel.INFO, "Invoking inner uncaught exception handler.", new Object[0]);
                this.defaultExceptionHandler.uncaughtException(thread, thrown);
            } else if (this.options.isPrintUncaughtStackTrace()) {
                thrown.printStackTrace();
            }
        }
    }

    @TestOnly
    @NotNull
    static Throwable getUnhandledThrowable(@NotNull Thread thread, @NotNull Throwable thrown) {
        Mechanism mechanism = new Mechanism();
        mechanism.setHandled(false);
        mechanism.setType("UncaughtExceptionHandler");
        return new ExceptionMechanismException(mechanism, thrown, thread);
    }

    @Override
    public void close() {
        if (this == this.threadAdapter.getDefaultUncaughtExceptionHandler()) {
            this.threadAdapter.setDefaultUncaughtExceptionHandler(this.defaultExceptionHandler);
            if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "UncaughtExceptionHandlerIntegration removed.", new Object[0]);
            }
        }
    }

    @ApiStatus.Internal
    public static class UncaughtExceptionHint
    extends BlockingFlushHint
    implements SessionEnd,
    TransactionEnd {
        private final AtomicReference<SentryId> flushableEventId = new AtomicReference();

        public UncaughtExceptionHint(long flushTimeoutMillis, @NotNull ILogger logger) {
            super(flushTimeoutMillis, logger);
        }

        @Override
        public boolean isFlushable(@Nullable SentryId eventId) {
            SentryId unwrapped = this.flushableEventId.get();
            return unwrapped != null && unwrapped.equals(eventId);
        }

        @Override
        public void setFlushable(@NotNull SentryId eventId) {
            this.flushableEventId.set(eventId);
        }
    }
}

