/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.cache;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CacheUtils {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    CacheUtils() {
    }

    static <T> void store(@NotNull SentryOptions options2, @NotNull T entity, @NotNull String dirName, @NotNull String fileName) {
        File cacheDir = CacheUtils.ensureCacheDir(options2, dirName);
        if (cacheDir == null) {
            options2.getLogger().log(SentryLevel.INFO, "Cache dir is not set, cannot store in scope cache", new Object[0]);
            return;
        }
        File file2 = new File(cacheDir, fileName);
        try (FileOutputStream outputStream2 = new FileOutputStream(file2);
             BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream2, UTF_8));){
            options2.getSerializer().serialize(entity, writer2);
        }
        catch (Throwable e) {
            options2.getLogger().log(SentryLevel.ERROR, e, "Error persisting entity: %s", fileName);
        }
    }

    static void delete(@NotNull SentryOptions options2, @NotNull String dirName, @NotNull String fileName) {
        File cacheDir = CacheUtils.ensureCacheDir(options2, dirName);
        if (cacheDir == null) {
            options2.getLogger().log(SentryLevel.INFO, "Cache dir is not set, cannot delete from scope cache", new Object[0]);
            return;
        }
        File file2 = new File(cacheDir, fileName);
        options2.getLogger().log(SentryLevel.DEBUG, "Deleting %s from scope cache", fileName);
        if (!file2.delete()) {
            options2.getLogger().log(SentryLevel.INFO, "Failed to delete: %s", file2.getAbsolutePath());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static <T, R> T read(@NotNull SentryOptions options2, @NotNull String dirName, @NotNull String fileName, @NotNull Class<T> clazz, @Nullable JsonDeserializer<R> elementDeserializer) {
        File cacheDir = CacheUtils.ensureCacheDir(options2, dirName);
        if (cacheDir == null) {
            options2.getLogger().log(SentryLevel.INFO, "Cache dir is not set, cannot read from scope cache", new Object[0]);
            return null;
        }
        File file2 = new File(cacheDir, fileName);
        if (!file2.exists()) {
            options2.getLogger().log(SentryLevel.DEBUG, "No entry stored for %s", fileName);
            return null;
        }
        try (BufferedReader reader2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), UTF_8));){
            if (elementDeserializer == null) {
                T t = options2.getSerializer().deserialize(reader2, clazz);
                return t;
            }
            T t = options2.getSerializer().deserializeCollection(reader2, clazz, elementDeserializer);
            return t;
        }
        catch (Throwable e) {
            options2.getLogger().log(SentryLevel.ERROR, e, "Error reading entity from scope cache: %s", fileName);
            return null;
        }
    }

    @Nullable
    static File ensureCacheDir(@NotNull SentryOptions options2, @NotNull String cacheDirName) {
        String cacheDir = options2.getCacheDirPath();
        if (cacheDir == null) {
            return null;
        }
        File dir = new File(cacheDir, cacheDirName);
        dir.mkdirs();
        return dir;
    }
}

