/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.clientreport;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.DateUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.clientreport.DiscardedEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ClientReport
implements JsonUnknown,
JsonSerializable {
    @NotNull
    private final Date timestamp;
    @NotNull
    private final List<DiscardedEvent> discardedEvents;
    @Nullable
    private Map<String, Object> unknown;

    public ClientReport(@NotNull Date timestamp2, @NotNull List<DiscardedEvent> discardedEvents) {
        this.timestamp = timestamp2;
        this.discardedEvents = discardedEvents;
    }

    @NotNull
    public Date getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public List<DiscardedEvent> getDiscardedEvents() {
        return this.discardedEvents;
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        writer2.name("timestamp").value(DateUtils.getTimestamp(this.timestamp));
        writer2.name("discarded_events").value(logger, this.discardedEvents);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key).value(logger, value2);
            }
        }
        writer2.endObject();
    }

    public static final class JsonKeys {
        public static final String TIMESTAMP = "timestamp";
        public static final String DISCARDED_EVENTS = "discarded_events";
    }

    public static final class Deserializer
    implements JsonDeserializer<ClientReport> {
        @Override
        @NotNull
        public ClientReport deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            Date timestamp2 = null;
            ArrayList<DiscardedEvent> discardedEvents = new ArrayList<DiscardedEvent>();
            HashMap<String, Object> unknown = null;
            reader2.beginObject();
            block8: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "timestamp": {
                        timestamp2 = reader2.nextDateOrNull(logger);
                        continue block8;
                    }
                    case "discarded_events": {
                        List<DiscardedEvent> deserializedDiscardedEvents = reader2.nextListOrNull(logger, new DiscardedEvent.Deserializer());
                        discardedEvents.addAll(deserializedDiscardedEvents);
                        continue block8;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            reader2.endObject();
            if (timestamp2 == null) {
                throw this.missingRequiredFieldException("timestamp", logger);
            }
            if (discardedEvents.isEmpty()) {
                throw this.missingRequiredFieldException("discarded_events", logger);
            }
            ClientReport clientReport = new ClientReport(timestamp2, discardedEvents);
            clientReport.setUnknown(unknown);
            return clientReport;
        }

        private Exception missingRequiredFieldException(String field2, ILogger logger) {
            String message2 = "Missing required field \"" + field2 + "\"";
            IllegalStateException exception = new IllegalStateException(message2);
            logger.log(SentryLevel.ERROR, message2, exception);
            return exception;
        }
    }
}

