/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.clientreport;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DiscardedEvent
implements JsonUnknown,
JsonSerializable {
    @NotNull
    private final String reason;
    @NotNull
    private final String category;
    @NotNull
    private final Long quantity;
    @Nullable
    private Map<String, Object> unknown;

    public DiscardedEvent(@NotNull String reason2, @NotNull String category, @NotNull Long quantity) {
        this.reason = reason2;
        this.category = category;
        this.quantity = quantity;
    }

    @NotNull
    public String getReason() {
        return this.reason;
    }

    @NotNull
    public String getCategory() {
        return this.category;
    }

    @NotNull
    public Long getQuantity() {
        return this.quantity;
    }

    public String toString() {
        return "DiscardedEvent{reason='" + this.reason + '\'' + ", category='" + this.category + '\'' + ", quantity=" + this.quantity + '}';
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        writer2.name("reason").value(this.reason);
        writer2.name("category").value(this.category);
        writer2.name("quantity").value(this.quantity);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key).value(logger, value2);
            }
        }
        writer2.endObject();
    }

    public static final class JsonKeys {
        public static final String REASON = "reason";
        public static final String CATEGORY = "category";
        public static final String QUANTITY = "quantity";
    }

    public static final class Deserializer
    implements JsonDeserializer<DiscardedEvent> {
        @Override
        @NotNull
        public DiscardedEvent deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            String reason2 = null;
            String category = null;
            Long quanity = null;
            HashMap<String, Object> unknown = null;
            reader2.beginObject();
            block10: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "reason": {
                        reason2 = reader2.nextStringOrNull();
                        continue block10;
                    }
                    case "category": {
                        category = reader2.nextStringOrNull();
                        continue block10;
                    }
                    case "quantity": {
                        quanity = reader2.nextLongOrNull();
                        continue block10;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            reader2.endObject();
            if (reason2 == null) {
                throw this.missingRequiredFieldException("reason", logger);
            }
            if (category == null) {
                throw this.missingRequiredFieldException("category", logger);
            }
            if (quanity == null) {
                throw this.missingRequiredFieldException("quantity", logger);
            }
            DiscardedEvent discardedEvent = new DiscardedEvent(reason2, category, quanity);
            discardedEvent.setUnknown(unknown);
            return discardedEvent;
        }

        private Exception missingRequiredFieldException(String field2, ILogger logger) {
            String message2 = "Missing required field \"" + field2 + "\"";
            IllegalStateException exception = new IllegalStateException(message2);
            logger.log(SentryLevel.ERROR, message2, exception);
            return exception;
        }
    }
}

