/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.config;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.config.PropertiesProvider;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractPropertiesProvider
implements PropertiesProvider {
    @NotNull
    private final String prefix;
    @NotNull
    private final Properties properties;

    protected AbstractPropertiesProvider(@NotNull String prefix2, @NotNull Properties properties) {
        this.prefix = Objects.requireNonNull(prefix2, "prefix is required");
        this.properties = Objects.requireNonNull(properties, "properties are required");
    }

    protected AbstractPropertiesProvider(@NotNull Properties properties) {
        this("", properties);
    }

    @Override
    @Nullable
    public String getProperty(@NotNull String property2) {
        return StringUtils.removeSurrounding(this.properties.getProperty(this.prefix + property2), "\"");
    }

    @Override
    @NotNull
    public Map<String, String> getMap(@NotNull String property2) {
        String prefix2 = this.prefix + property2 + ".";
        HashMap<String, String> result2 = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String key;
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !(key = (String)entry.getKey()).startsWith(prefix2)) continue;
            String value2 = StringUtils.removeSurrounding((String)entry.getValue(), "\"");
            result2.put(key.substring(prefix2.length()), value2);
        }
        return result2;
    }
}

