/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.config;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.config.PropertiesProvider;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.StringUtils;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EnvironmentVariablePropertiesProvider
implements PropertiesProvider {
    private static final String PREFIX = "SENTRY";

    EnvironmentVariablePropertiesProvider() {
    }

    @Override
    @Nullable
    public String getProperty(@NotNull String property2) {
        return StringUtils.removeSurrounding(System.getenv(this.propertyToEnvironmentVariableName(property2)), "\"");
    }

    @Override
    @NotNull
    public Map<String, String> getMap(@NotNull String property2) {
        String prefix2 = this.propertyToEnvironmentVariableName(property2) + "_";
        ConcurrentHashMap<String, @NotNull String> result2 = new ConcurrentHashMap<String, String>();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String value2;
            String key = entry.getKey();
            if (!key.startsWith(prefix2) || (value2 = StringUtils.removeSurrounding(entry.getValue(), "\"")) == null) continue;
            result2.put(key.substring(prefix2.length()).toLowerCase(Locale.ROOT), value2);
        }
        return result2;
    }

    @NotNull
    private String propertyToEnvironmentVariableName(@NotNull String property2) {
        return "SENTRY_" + property2.replace(".", "_").replace("-", "_").toUpperCase(Locale.ROOT);
    }
}

