/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.profilemeasurements;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.profilemeasurements.ProfileMeasurementValue;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ProfileMeasurement
implements JsonUnknown,
JsonSerializable {
    public static final String ID_FROZEN_FRAME_RENDERS = "frozen_frame_renders";
    public static final String ID_SLOW_FRAME_RENDERS = "slow_frame_renders";
    public static final String ID_SCREEN_FRAME_RATES = "screen_frame_rates";
    public static final String ID_CPU_USAGE = "cpu_usage";
    public static final String ID_MEMORY_FOOTPRINT = "memory_footprint";
    public static final String ID_MEMORY_NATIVE_FOOTPRINT = "memory_native_footprint";
    public static final String ID_UNKNOWN = "unknown";
    public static final String UNIT_HZ = "hz";
    public static final String UNIT_NANOSECONDS = "nanosecond";
    public static final String UNIT_BYTES = "byte";
    public static final String UNIT_PERCENT = "percent";
    public static final String UNIT_UNKNOWN = "unknown";
    @Nullable
    private Map<String, Object> unknown;
    @NotNull
    private String unit;
    @NotNull
    private Collection<ProfileMeasurementValue> values;

    public ProfileMeasurement() {
        this("unknown", new ArrayList<ProfileMeasurementValue>());
    }

    public ProfileMeasurement(@NotNull String unit, @NotNull Collection<ProfileMeasurementValue> values2) {
        this.unit = unit;
        this.values = values2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileMeasurement that = (ProfileMeasurement)o;
        return Objects.equals(this.unknown, that.unknown) && this.unit.equals(that.unit) && new ArrayList<ProfileMeasurementValue>(this.values).equals(new ArrayList<ProfileMeasurementValue>(that.values));
    }

    public int hashCode() {
        return Objects.hash(this.unknown, this.unit, this.values);
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        writer2.name("unit").value(logger, this.unit);
        writer2.name("values").value(logger, this.values);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @NotNull
    public String getUnit() {
        return this.unit;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public void setUnit(@NotNull String unit) {
        this.unit = unit;
    }

    @NotNull
    public Collection<ProfileMeasurementValue> getValues() {
        return this.values;
    }

    public void setValues(@NotNull Collection<ProfileMeasurementValue> values2) {
        this.values = values2;
    }

    public static final class JsonKeys {
        public static final String UNIT = "unit";
        public static final String VALUES = "values";
    }

    public static final class Deserializer
    implements JsonDeserializer<ProfileMeasurement> {
        @Override
        @NotNull
        public ProfileMeasurement deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            reader2.beginObject();
            ProfileMeasurement data2 = new ProfileMeasurement();
            ConcurrentHashMap<String, Object> unknown = null;
            block8: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "unit": {
                        String unit = reader2.nextStringOrNull();
                        if (unit == null) continue block8;
                        data2.unit = unit;
                        continue block8;
                    }
                    case "values": {
                        List<ProfileMeasurementValue> values2 = reader2.nextListOrNull(logger, new ProfileMeasurementValue.Deserializer());
                        if (values2 == null) continue block8;
                        data2.values = values2;
                        continue block8;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            data2.setUnknown(unknown);
            reader2.endObject();
            return data2;
        }
    }
}

