/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.CollectionUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Mechanism
implements JsonUnknown,
JsonSerializable {
    @Nullable
    private final transient Thread thread;
    @Nullable
    private String type;
    @Nullable
    private String description;
    @Nullable
    private String helpLink;
    @Nullable
    private Boolean handled;
    @Nullable
    private Map<String, Object> meta;
    @Nullable
    private Map<String, Object> data;
    @Nullable
    private Boolean synthetic;
    @Nullable
    private Integer exceptionId;
    @Nullable
    private Integer parentId;
    @Nullable
    private Boolean exceptionGroup;
    @Nullable
    private Map<String, Object> unknown;

    public Mechanism() {
        this(null);
    }

    public Mechanism(@Nullable Thread thread) {
        this.thread = thread;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setType(@Nullable String type) {
        this.type = type;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description2) {
        this.description = description2;
    }

    @Nullable
    public String getHelpLink() {
        return this.helpLink;
    }

    public void setHelpLink(@Nullable String helpLink) {
        this.helpLink = helpLink;
    }

    @Nullable
    public Boolean isHandled() {
        return this.handled;
    }

    public void setHandled(@Nullable Boolean handled) {
        this.handled = handled;
    }

    @Nullable
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    public void setMeta(@Nullable Map<String, Object> meta) {
        this.meta = CollectionUtils.newHashMap(meta);
    }

    @Nullable
    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(@Nullable Map<String, Object> data2) {
        this.data = CollectionUtils.newHashMap(data2);
    }

    @Nullable
    Thread getThread() {
        return this.thread;
    }

    @Nullable
    public Boolean getSynthetic() {
        return this.synthetic;
    }

    public void setSynthetic(@Nullable Boolean synthetic) {
        this.synthetic = synthetic;
    }

    @Nullable
    public Integer getExceptionId() {
        return this.exceptionId;
    }

    public void setExceptionId(@Nullable Integer exceptionId) {
        this.exceptionId = exceptionId;
    }

    @Nullable
    public Integer getParentId() {
        return this.parentId;
    }

    public void setParentId(@Nullable Integer parentId2) {
        this.parentId = parentId2;
    }

    @Nullable
    public Boolean isExceptionGroup() {
        return this.exceptionGroup;
    }

    public void setExceptionGroup(@Nullable Boolean exceptionGroup) {
        this.exceptionGroup = exceptionGroup;
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        if (this.type != null) {
            writer2.name("type").value(this.type);
        }
        if (this.description != null) {
            writer2.name("description").value(this.description);
        }
        if (this.helpLink != null) {
            writer2.name("help_link").value(this.helpLink);
        }
        if (this.handled != null) {
            writer2.name("handled").value(this.handled);
        }
        if (this.meta != null) {
            writer2.name("meta").value(logger, this.meta);
        }
        if (this.data != null) {
            writer2.name("data").value(logger, this.data);
        }
        if (this.synthetic != null) {
            writer2.name("synthetic").value(this.synthetic);
        }
        if (this.exceptionId != null) {
            writer2.name("exception_id").value(logger, this.exceptionId);
        }
        if (this.parentId != null) {
            writer2.name("parent_id").value(logger, this.parentId);
        }
        if (this.exceptionGroup != null) {
            writer2.name("is_exception_group").value(this.exceptionGroup);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key).value(logger, value2);
            }
        }
        writer2.endObject();
    }

    public static final class JsonKeys {
        public static final String TYPE = "type";
        public static final String DESCRIPTION = "description";
        public static final String HELP_LINK = "help_link";
        public static final String HANDLED = "handled";
        public static final String META = "meta";
        public static final String DATA = "data";
        public static final String SYNTHETIC = "synthetic";
        public static final String EXCEPTION_ID = "exception_id";
        public static final String PARENT_ID = "parent_id";
        public static final String IS_EXCEPTION_GROUP = "is_exception_group";
    }

    public static final class Deserializer
    implements JsonDeserializer<Mechanism> {
        @Override
        @NotNull
        public Mechanism deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            Mechanism mechanism = new Mechanism();
            HashMap<String, Object> unknown = null;
            reader2.beginObject();
            block24: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "type": {
                        mechanism.type = reader2.nextStringOrNull();
                        continue block24;
                    }
                    case "description": {
                        mechanism.description = reader2.nextStringOrNull();
                        continue block24;
                    }
                    case "help_link": {
                        mechanism.helpLink = reader2.nextStringOrNull();
                        continue block24;
                    }
                    case "handled": {
                        mechanism.handled = reader2.nextBooleanOrNull();
                        continue block24;
                    }
                    case "meta": {
                        mechanism.meta = CollectionUtils.newConcurrentHashMap((Map)reader2.nextObjectOrNull());
                        continue block24;
                    }
                    case "data": {
                        mechanism.data = CollectionUtils.newConcurrentHashMap((Map)reader2.nextObjectOrNull());
                        continue block24;
                    }
                    case "synthetic": {
                        mechanism.synthetic = reader2.nextBooleanOrNull();
                        continue block24;
                    }
                    case "exception_id": {
                        mechanism.exceptionId = reader2.nextIntegerOrNull();
                        continue block24;
                    }
                    case "parent_id": {
                        mechanism.parentId = reader2.nextIntegerOrNull();
                        continue block24;
                    }
                    case "is_exception_group": {
                        mechanism.exceptionGroup = reader2.nextBooleanOrNull();
                        continue block24;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            reader2.endObject();
            mechanism.setUnknown(unknown);
            return mechanism;
        }
    }
}

