/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.CollectionUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Response
implements JsonUnknown,
JsonSerializable {
    public static final String TYPE = "response";
    @Nullable
    private String cookies;
    @Nullable
    private Map<String, String> headers;
    @Nullable
    private Integer statusCode;
    @Nullable
    private Long bodySize;
    @Nullable
    private Object data;
    @Nullable
    private Map<String, Object> unknown;

    public Response() {
    }

    public Response(@NotNull Response response2) {
        this.cookies = response2.cookies;
        this.headers = CollectionUtils.newConcurrentHashMap(response2.headers);
        this.unknown = CollectionUtils.newConcurrentHashMap(response2.unknown);
        this.statusCode = response2.statusCode;
        this.bodySize = response2.bodySize;
        this.data = response2.data;
    }

    @Nullable
    public String getCookies() {
        return this.cookies;
    }

    public void setCookies(@Nullable String cookies) {
        this.cookies = cookies;
    }

    @Nullable
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(@Nullable Map<String, String> headers) {
        this.headers = CollectionUtils.newConcurrentHashMap(headers);
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Nullable
    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(@Nullable Integer statusCode) {
        this.statusCode = statusCode;
    }

    @Nullable
    public Long getBodySize() {
        return this.bodySize;
    }

    public void setBodySize(@Nullable Long bodySize) {
        this.bodySize = bodySize;
    }

    @Nullable
    public Object getData() {
        return this.data;
    }

    public void setData(@Nullable Object data2) {
        this.data = data2;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        if (this.cookies != null) {
            writer2.name("cookies").value(this.cookies);
        }
        if (this.headers != null) {
            writer2.name("headers").value(logger, this.headers);
        }
        if (this.statusCode != null) {
            writer2.name("status_code").value(logger, this.statusCode);
        }
        if (this.bodySize != null) {
            writer2.name("body_size").value(logger, this.bodySize);
        }
        if (this.data != null) {
            writer2.name("data").value(logger, this.data);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    public static final class JsonKeys {
        public static final String COOKIES = "cookies";
        public static final String HEADERS = "headers";
        public static final String STATUS_CODE = "status_code";
        public static final String BODY_SIZE = "body_size";
        public static final String DATA = "data";
    }

    public static final class Deserializer
    implements JsonDeserializer<Response> {
        @Override
        @NotNull
        public Response deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            reader2.beginObject();
            Response response2 = new Response();
            ConcurrentHashMap<String, Object> unknown = null;
            block14: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "cookies": {
                        response2.cookies = reader2.nextStringOrNull();
                        continue block14;
                    }
                    case "headers": {
                        Map deserializedHeaders = (Map)reader2.nextObjectOrNull();
                        if (deserializedHeaders == null) continue block14;
                        response2.headers = CollectionUtils.newConcurrentHashMap(deserializedHeaders);
                        continue block14;
                    }
                    case "status_code": {
                        response2.statusCode = reader2.nextIntegerOrNull();
                        continue block14;
                    }
                    case "body_size": {
                        response2.bodySize = reader2.nextLongOrNull();
                        continue block14;
                    }
                    case "data": {
                        response2.data = reader2.nextObjectOrNull();
                        continue block14;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            response2.setUnknown(unknown);
            reader2.endObject();
            return response2;
        }
    }
}

