/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.DateUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Span;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanStatus;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.MeasurementValue;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryId;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.CollectionUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentrySpan
implements JsonUnknown,
JsonSerializable {
    @NotNull
    private final Double startTimestamp;
    @Nullable
    private final Double timestamp;
    @NotNull
    private final SentryId traceId;
    @NotNull
    private final SpanId spanId;
    @Nullable
    private final SpanId parentSpanId;
    @NotNull
    private final String op;
    @Nullable
    private final String description;
    @Nullable
    private final SpanStatus status;
    @Nullable
    private final String origin;
    @NotNull
    private final Map<String, String> tags;
    @Nullable
    private Map<String, Object> data;
    @NotNull
    private final @NotNull Map<String, @NotNull MeasurementValue> measurements;
    @Nullable
    private Map<String, Object> unknown;

    public SentrySpan(@NotNull Span span) {
        this(span, span.getData());
    }

    @ApiStatus.Internal
    public SentrySpan(@NotNull Span span, @Nullable Map<String, Object> data2) {
        Objects.requireNonNull(span, "span is required");
        this.description = span.getDescription();
        this.op = span.getOperation();
        this.spanId = span.getSpanId();
        this.parentSpanId = span.getParentSpanId();
        this.traceId = span.getTraceId();
        this.status = span.getStatus();
        this.origin = span.getSpanContext().getOrigin();
        ConcurrentHashMap tagsCopy = CollectionUtils.newConcurrentHashMap(span.getTags());
        this.tags = tagsCopy != null ? tagsCopy : new ConcurrentHashMap();
        ConcurrentHashMap measurementsCopy = CollectionUtils.newConcurrentHashMap(span.getMeasurements());
        this.measurements = measurementsCopy != null ? measurementsCopy : new ConcurrentHashMap();
        this.timestamp = span.getFinishDate() == null ? null : Double.valueOf(DateUtils.nanosToSeconds(span.getStartDate().laterDateNanosTimestampByDiff(span.getFinishDate())));
        this.startTimestamp = DateUtils.nanosToSeconds(span.getStartDate().nanoTimestamp());
        this.data = data2;
    }

    @ApiStatus.Internal
    public SentrySpan(@NotNull Double startTimestamp, @Nullable Double timestamp2, @NotNull SentryId traceId, @NotNull SpanId spanId, @Nullable SpanId parentSpanId, @NotNull String op, @Nullable String description2, @Nullable SpanStatus status2, @Nullable String origin, @NotNull Map<String, String> tags2, @NotNull Map<String, MeasurementValue> measurements, @Nullable Map<String, Object> data2) {
        this.startTimestamp = startTimestamp;
        this.timestamp = timestamp2;
        this.traceId = traceId;
        this.spanId = spanId;
        this.parentSpanId = parentSpanId;
        this.op = op;
        this.description = description2;
        this.status = status2;
        this.origin = origin;
        this.tags = tags2;
        this.measurements = measurements;
        this.data = data2;
    }

    public boolean isFinished() {
        return this.timestamp != null;
    }

    @NotNull
    public Double getStartTimestamp() {
        return this.startTimestamp;
    }

    @Nullable
    public Double getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public SentryId getTraceId() {
        return this.traceId;
    }

    @NotNull
    public SpanId getSpanId() {
        return this.spanId;
    }

    @Nullable
    public SpanId getParentSpanId() {
        return this.parentSpanId;
    }

    @NotNull
    public String getOp() {
        return this.op;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public SpanStatus getStatus() {
        return this.status;
    }

    @NotNull
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Nullable
    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(@Nullable Map<String, Object> data2) {
        this.data = data2;
    }

    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    @NotNull
    public Map<String, MeasurementValue> getMeasurements() {
        return this.measurements;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        writer2.name("start_timestamp").value(logger, this.doubleToBigDecimal(this.startTimestamp));
        if (this.timestamp != null) {
            writer2.name("timestamp").value(logger, this.doubleToBigDecimal(this.timestamp));
        }
        writer2.name("trace_id").value(logger, this.traceId);
        writer2.name("span_id").value(logger, this.spanId);
        if (this.parentSpanId != null) {
            writer2.name("parent_span_id").value(logger, this.parentSpanId);
        }
        writer2.name("op").value(this.op);
        if (this.description != null) {
            writer2.name("description").value(this.description);
        }
        if (this.status != null) {
            writer2.name("status").value(logger, this.status);
        }
        if (this.origin != null) {
            writer2.name("origin").value(logger, this.origin);
        }
        if (!this.tags.isEmpty()) {
            writer2.name("tags").value(logger, this.tags);
        }
        if (this.data != null) {
            writer2.name("data").value(logger, this.data);
        }
        if (!this.measurements.isEmpty()) {
            writer2.name("measurements").value(logger, this.measurements);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    @NotNull
    private BigDecimal doubleToBigDecimal(@NotNull Double value2) {
        return BigDecimal.valueOf(value2).setScale(6, RoundingMode.DOWN);
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class JsonKeys {
        public static final String START_TIMESTAMP = "start_timestamp";
        public static final String TIMESTAMP = "timestamp";
        public static final String TRACE_ID = "trace_id";
        public static final String SPAN_ID = "span_id";
        public static final String PARENT_SPAN_ID = "parent_span_id";
        public static final String OP = "op";
        public static final String DESCRIPTION = "description";
        public static final String STATUS = "status";
        public static final String ORIGIN = "origin";
        public static final String TAGS = "tags";
        public static final String MEASUREMENTS = "measurements";
        public static final String DATA = "data";
    }

    public static final class Deserializer
    implements JsonDeserializer<SentrySpan> {
        @Override
        @NotNull
        public SentrySpan deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            reader2.beginObject();
            Double startTimestamp = null;
            Double timestamp2 = null;
            SentryId traceId = null;
            SpanId spanId = null;
            SpanId parentSpanId = null;
            String op = null;
            String description2 = null;
            SpanStatus status2 = null;
            String origin = null;
            HashMap<String, String> tags2 = null;
            HashMap<String, MeasurementValue> measurements = null;
            Map data2 = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block32: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "start_timestamp": {
                        Date date;
                        try {
                            startTimestamp = reader2.nextDoubleOrNull();
                        }
                        catch (NumberFormatException e) {
                            date = reader2.nextDateOrNull(logger);
                            startTimestamp = date != null ? Double.valueOf(DateUtils.dateToSeconds(date)) : null;
                        }
                        continue block32;
                    }
                    case "timestamp": {
                        Date date;
                        try {
                            timestamp2 = reader2.nextDoubleOrNull();
                        }
                        catch (NumberFormatException e) {
                            date = reader2.nextDateOrNull(logger);
                            timestamp2 = date != null ? Double.valueOf(DateUtils.dateToSeconds(date)) : null;
                        }
                        continue block32;
                    }
                    case "trace_id": {
                        traceId = new SentryId.Deserializer().deserialize(reader2, logger);
                        continue block32;
                    }
                    case "span_id": {
                        spanId = new SpanId.Deserializer().deserialize(reader2, logger);
                        continue block32;
                    }
                    case "parent_span_id": {
                        parentSpanId = reader2.nextOrNull(logger, new SpanId.Deserializer());
                        continue block32;
                    }
                    case "op": {
                        op = reader2.nextStringOrNull();
                        continue block32;
                    }
                    case "description": {
                        description2 = reader2.nextStringOrNull();
                        continue block32;
                    }
                    case "status": {
                        status2 = reader2.nextOrNull(logger, new SpanStatus.Deserializer());
                        continue block32;
                    }
                    case "origin": {
                        origin = reader2.nextStringOrNull();
                        continue block32;
                    }
                    case "tags": {
                        tags2 = (Map)reader2.nextObjectOrNull();
                        continue block32;
                    }
                    case "data": {
                        data2 = (Map)reader2.nextObjectOrNull();
                        continue block32;
                    }
                    case "measurements": {
                        measurements = reader2.nextMapOrNull(logger, new MeasurementValue.Deserializer());
                        continue block32;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            if (startTimestamp == null) {
                throw this.missingRequiredFieldException("start_timestamp", logger);
            }
            if (traceId == null) {
                throw this.missingRequiredFieldException("trace_id", logger);
            }
            if (spanId == null) {
                throw this.missingRequiredFieldException("span_id", logger);
            }
            if (op == null) {
                throw this.missingRequiredFieldException("op", logger);
            }
            if (tags2 == null) {
                tags2 = new HashMap();
            }
            if (measurements == null) {
                measurements = new HashMap();
            }
            SentrySpan sentrySpan = new SentrySpan(startTimestamp, timestamp2, traceId, spanId, parentSpanId, op, description2, status2, origin, tags2, measurements, data2);
            sentrySpan.setUnknown(unknown);
            reader2.endObject();
            return sentrySpan;
        }

        private Exception missingRequiredFieldException(String field2, ILogger logger) {
            String message2 = "Missing required field \"" + field2 + "\"";
            IllegalStateException exception = new IllegalStateException(message2);
            logger.log(SentryLevel.ERROR, message2, exception);
            return exception;
        }
    }
}

