/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLockReason;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentryStackTrace;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryThread
implements JsonUnknown,
JsonSerializable {
    @Nullable
    private Long id;
    @Nullable
    private Integer priority;
    @Nullable
    private String name;
    @Nullable
    private String state;
    @Nullable
    private Boolean crashed;
    @Nullable
    private Boolean current;
    @Nullable
    private Boolean daemon;
    @Nullable
    private Boolean main;
    @Nullable
    private SentryStackTrace stacktrace;
    @Nullable
    private Map<String, SentryLockReason> heldLocks;
    @Nullable
    private Map<String, Object> unknown;

    @Nullable
    public Long getId() {
        return this.id;
    }

    public void setId(@Nullable Long id2) {
        this.id = id2;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name2) {
        this.name = name2;
    }

    @Nullable
    public Boolean isCrashed() {
        return this.crashed;
    }

    public void setCrashed(@Nullable Boolean crashed) {
        this.crashed = crashed;
    }

    @Nullable
    public Boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(@Nullable Boolean current) {
        this.current = current;
    }

    @Nullable
    public SentryStackTrace getStacktrace() {
        return this.stacktrace;
    }

    public void setStacktrace(@Nullable SentryStackTrace stacktrace) {
        this.stacktrace = stacktrace;
    }

    @Nullable
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(@Nullable Integer priority) {
        this.priority = priority;
    }

    @Nullable
    public Boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(@Nullable Boolean daemon) {
        this.daemon = daemon;
    }

    @Nullable
    public Boolean isMain() {
        return this.main;
    }

    public void setMain(@Nullable Boolean main) {
        this.main = main;
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    public void setState(@Nullable String state2) {
        this.state = state2;
    }

    @Nullable
    public Map<String, SentryLockReason> getHeldLocks() {
        return this.heldLocks;
    }

    public void setHeldLocks(@Nullable Map<String, SentryLockReason> heldLocks) {
        this.heldLocks = heldLocks;
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        if (this.id != null) {
            writer2.name("id").value(this.id);
        }
        if (this.priority != null) {
            writer2.name("priority").value(this.priority);
        }
        if (this.name != null) {
            writer2.name("name").value(this.name);
        }
        if (this.state != null) {
            writer2.name("state").value(this.state);
        }
        if (this.crashed != null) {
            writer2.name("crashed").value(this.crashed);
        }
        if (this.current != null) {
            writer2.name("current").value(this.current);
        }
        if (this.daemon != null) {
            writer2.name("daemon").value(this.daemon);
        }
        if (this.main != null) {
            writer2.name("main").value(this.main);
        }
        if (this.stacktrace != null) {
            writer2.name("stacktrace").value(logger, this.stacktrace);
        }
        if (this.heldLocks != null) {
            writer2.name("held_locks").value(logger, this.heldLocks);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    public static final class JsonKeys {
        public static final String ID = "id";
        public static final String PRIORITY = "priority";
        public static final String NAME = "name";
        public static final String STATE = "state";
        public static final String CRASHED = "crashed";
        public static final String CURRENT = "current";
        public static final String DAEMON = "daemon";
        public static final String MAIN = "main";
        public static final String STACKTRACE = "stacktrace";
        public static final String HELD_LOCKS = "held_locks";
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryThread> {
        @Override
        @NotNull
        public SentryThread deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            SentryThread sentryThread = new SentryThread();
            ConcurrentHashMap<String, Object> unknown = null;
            reader2.beginObject();
            block24: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "id": {
                        sentryThread.id = reader2.nextLongOrNull();
                        continue block24;
                    }
                    case "priority": {
                        sentryThread.priority = reader2.nextIntegerOrNull();
                        continue block24;
                    }
                    case "name": {
                        sentryThread.name = reader2.nextStringOrNull();
                        continue block24;
                    }
                    case "state": {
                        sentryThread.state = reader2.nextStringOrNull();
                        continue block24;
                    }
                    case "crashed": {
                        sentryThread.crashed = reader2.nextBooleanOrNull();
                        continue block24;
                    }
                    case "current": {
                        sentryThread.current = reader2.nextBooleanOrNull();
                        continue block24;
                    }
                    case "daemon": {
                        sentryThread.daemon = reader2.nextBooleanOrNull();
                        continue block24;
                    }
                    case "main": {
                        sentryThread.main = reader2.nextBooleanOrNull();
                        continue block24;
                    }
                    case "stacktrace": {
                        sentryThread.stacktrace = reader2.nextOrNull(logger, new SentryStackTrace.Deserializer());
                        continue block24;
                    }
                    case "held_locks": {
                        Map<String, SentryLockReason> heldLocks = reader2.nextMapOrNull(logger, new SentryLockReason.Deserializer());
                        if (heldLocks == null) continue block24;
                        sentryThread.heldLocks = new HashMap<String, SentryLockReason>(heldLocks);
                        continue block24;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            sentryThread.setUnknown(unknown);
            reader2.endObject();
            return sentryThread;
        }
    }
}

