/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.DateUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryBaseEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryTracer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Span;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanContext;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SpanStatus;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.TracesSamplingDecision;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Contexts;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.MeasurementValue;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.SentrySpan;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.TransactionInfo;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.TransactionNameSource;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryTransaction
extends SentryBaseEvent
implements JsonUnknown,
JsonSerializable {
    @Nullable
    private String transaction;
    @NotNull
    private Double startTimestamp;
    @Nullable
    private Double timestamp;
    @NotNull
    private final List<SentrySpan> spans = new ArrayList<SentrySpan>();
    @NotNull
    private final String type = "transaction";
    @NotNull
    private final @NotNull Map<String, @NotNull MeasurementValue> measurements = new HashMap<String, MeasurementValue>();
    @NotNull
    private TransactionInfo transactionInfo;
    @Nullable
    private Map<String, Object> unknown;

    public SentryTransaction(@NotNull SentryTracer sentryTracer) {
        super(sentryTracer.getEventId());
        Objects.requireNonNull(sentryTracer, "sentryTracer is required");
        this.startTimestamp = DateUtils.nanosToSeconds(sentryTracer.getStartDate().nanoTimestamp());
        this.timestamp = DateUtils.nanosToSeconds(sentryTracer.getStartDate().laterDateNanosTimestampByDiff(sentryTracer.getFinishDate()));
        this.transaction = sentryTracer.getName();
        for (Span span : sentryTracer.getChildren()) {
            if (!Boolean.TRUE.equals(span.isSampled())) continue;
            this.spans.add(new SentrySpan(span));
        }
        Contexts contexts = this.getContexts();
        contexts.putAll(sentryTracer.getContexts());
        SpanContext tracerContext = sentryTracer.getSpanContext();
        Map<String, Object> data2 = sentryTracer.getData();
        @NotNull SpanContext tracerContextToSend = new SpanContext(tracerContext.getTraceId(), tracerContext.getSpanId(), tracerContext.getParentSpanId(), tracerContext.getOperation(), tracerContext.getDescription(), tracerContext.getSamplingDecision(), tracerContext.getStatus(), tracerContext.getOrigin());
        for (Map.Entry<String, String> entry : tracerContext.getTags().entrySet()) {
            this.setTag(entry.getKey(), entry.getValue());
        }
        if (data2 != null) {
            for (Map.Entry<String, Object> entry : data2.entrySet()) {
                tracerContextToSend.setData(entry.getKey(), entry.getValue());
            }
        }
        contexts.setTrace(tracerContextToSend);
        this.transactionInfo = new TransactionInfo(sentryTracer.getTransactionNameSource().apiName());
    }

    @ApiStatus.Internal
    public SentryTransaction(@Nullable String transaction, @NotNull Double startTimestamp, @Nullable Double timestamp2, @NotNull List<SentrySpan> spans, @NotNull @NotNull Map<String, @NotNull MeasurementValue> measurements, @NotNull TransactionInfo transactionInfo) {
        this.transaction = transaction;
        this.startTimestamp = startTimestamp;
        this.timestamp = timestamp2;
        this.spans.addAll(spans);
        this.measurements.putAll(measurements);
        for (SentrySpan span : spans) {
            this.measurements.putAll(span.getMeasurements());
        }
        this.transactionInfo = transactionInfo;
    }

    @NotNull
    public List<SentrySpan> getSpans() {
        return this.spans;
    }

    public boolean isFinished() {
        return this.timestamp != null;
    }

    @Nullable
    public String getTransaction() {
        return this.transaction;
    }

    @NotNull
    public Double getStartTimestamp() {
        return this.startTimestamp;
    }

    @Nullable
    public Double getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public String getType() {
        return "transaction";
    }

    @Nullable
    public SpanStatus getStatus() {
        SpanContext trace = this.getContexts().getTrace();
        return trace != null ? trace.getStatus() : null;
    }

    public boolean isSampled() {
        @Nullable TracesSamplingDecision samplingDecsion = this.getSamplingDecision();
        if (samplingDecsion == null) {
            return false;
        }
        return samplingDecsion.getSampled();
    }

    @Nullable
    public TracesSamplingDecision getSamplingDecision() {
        SpanContext trace = this.getContexts().getTrace();
        if (trace == null) {
            return null;
        }
        return trace.getSamplingDecision();
    }

    @NotNull
    public @NotNull Map<String, @NotNull MeasurementValue> getMeasurements() {
        return this.measurements;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        if (this.transaction != null) {
            writer2.name("transaction").value(this.transaction);
        }
        writer2.name("start_timestamp").value(logger, DateUtils.doubleToBigDecimal(this.startTimestamp));
        if (this.timestamp != null) {
            writer2.name("timestamp").value(logger, DateUtils.doubleToBigDecimal(this.timestamp));
        }
        if (!this.spans.isEmpty()) {
            writer2.name("spans").value(logger, this.spans);
        }
        writer2.name("type").value("transaction");
        if (!this.measurements.isEmpty()) {
            writer2.name("measurements").value(logger, this.measurements);
        }
        writer2.name("transaction_info").value(logger, this.transactionInfo);
        new SentryBaseEvent.Serializer().serialize(this, writer2, logger);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class JsonKeys {
        public static final String TRANSACTION = "transaction";
        public static final String START_TIMESTAMP = "start_timestamp";
        public static final String TIMESTAMP = "timestamp";
        public static final String SPANS = "spans";
        public static final String TYPE = "type";
        public static final String MEASUREMENTS = "measurements";
        public static final String TRANSACTION_INFO = "transaction_info";
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryTransaction> {
        @Override
        @NotNull
        public SentryTransaction deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            reader2.beginObject();
            SentryTransaction transaction = new SentryTransaction("", 0.0, null, new ArrayList<SentrySpan>(), new HashMap<String, MeasurementValue>(), new TransactionInfo(TransactionNameSource.CUSTOM.apiName()));
            ConcurrentHashMap<String, Object> unknown = null;
            SentryBaseEvent.Deserializer baseEventDeserializer = new SentryBaseEvent.Deserializer();
            block22: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "transaction": {
                        transaction.transaction = reader2.nextStringOrNull();
                        break;
                    }
                    case "start_timestamp": {
                        Date date;
                        try {
                            Double deserializedStartTimestamp = reader2.nextDoubleOrNull();
                            if (deserializedStartTimestamp == null) continue block22;
                            transaction.startTimestamp = deserializedStartTimestamp;
                        }
                        catch (NumberFormatException e) {
                            date = reader2.nextDateOrNull(logger);
                            if (date == null) continue block22;
                            transaction.startTimestamp = DateUtils.dateToSeconds(date);
                        }
                        break;
                    }
                    case "timestamp": {
                        Date date;
                        try {
                            Double deserializedTimestamp = reader2.nextDoubleOrNull();
                            if (deserializedTimestamp == null) continue block22;
                            transaction.timestamp = deserializedTimestamp;
                        }
                        catch (NumberFormatException e) {
                            date = reader2.nextDateOrNull(logger);
                            if (date == null) continue block22;
                            transaction.timestamp = DateUtils.dateToSeconds(date);
                        }
                        break;
                    }
                    case "spans": {
                        List<SentrySpan> deserializedSpans = reader2.nextListOrNull(logger, new SentrySpan.Deserializer());
                        if (deserializedSpans == null) continue block22;
                        transaction.spans.addAll(deserializedSpans);
                        break;
                    }
                    case "type": {
                        reader2.nextString();
                        break;
                    }
                    case "measurements": {
                        Map<String, MeasurementValue> deserializedMeasurements = reader2.nextMapOrNull(logger, new MeasurementValue.Deserializer());
                        if (deserializedMeasurements == null) continue block22;
                        transaction.measurements.putAll(deserializedMeasurements);
                        break;
                    }
                    case "transaction_info": {
                        transaction.transactionInfo = new TransactionInfo.Deserializer().deserialize(reader2, logger);
                        break;
                    }
                    default: {
                        if (baseEventDeserializer.deserializeValue(transaction, nextName, reader2, logger)) continue block22;
                        if (unknown == null) {
                            unknown = new ConcurrentHashMap<String, Object>();
                        }
                        reader2.nextUnknown(logger, unknown, nextName);
                    }
                }
            }
            transaction.setUnknown(unknown);
            reader2.endObject();
            return transaction;
        }
    }
}

