/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryOptions;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Geo;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.CollectionUtils;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class User
implements JsonUnknown,
JsonSerializable {
    @Nullable
    private String email;
    @Nullable
    private String id;
    @Nullable
    private String username;
    @Nullable
    private String ipAddress;
    @Nullable
    private String name;
    @Nullable
    private Geo geo;
    private @Nullable Map<String, @NotNull String> data;
    private @Nullable Map<String, @NotNull Object> unknown;

    public User() {
    }

    public User(@NotNull User user2) {
        this.email = user2.email;
        this.username = user2.username;
        this.id = user2.id;
        this.ipAddress = user2.ipAddress;
        this.name = user2.name;
        this.geo = user2.geo;
        this.data = CollectionUtils.newConcurrentHashMap(user2.data);
        this.unknown = CollectionUtils.newConcurrentHashMap(user2.unknown);
    }

    public static User fromMap(@NotNull Map<String, Object> map2, @NotNull SentryOptions options2) {
        User user2 = new User();
        ConcurrentHashMap<String, Object> unknown = null;
        block18: for (Map.Entry<String, Object> entry : map2.entrySet()) {
            Object value2 = entry.getValue();
            switch (entry.getKey()) {
                case "email": {
                    user2.email = value2 instanceof String ? (String)value2 : null;
                    continue block18;
                }
                case "id": {
                    user2.id = value2 instanceof String ? (String)value2 : null;
                    continue block18;
                }
                case "username": {
                    user2.username = value2 instanceof String ? (String)value2 : null;
                    continue block18;
                }
                case "ip_address": {
                    user2.ipAddress = value2 instanceof String ? (String)value2 : null;
                    continue block18;
                }
                case "name": {
                    user2.name = value2 instanceof String ? (String)value2 : null;
                    continue block18;
                }
                case "geo": {
                    Map geo = value2 instanceof Map ? (Map)value2 : null;
                    if (geo == null) continue block18;
                    ConcurrentHashMap<String, Object> geoData = new ConcurrentHashMap<String, Object>();
                    for (Map.Entry geoEntry : geo.entrySet()) {
                        if (geoEntry.getKey() instanceof String && geoEntry.getValue() != null) {
                            geoData.put((String)geoEntry.getKey(), geoEntry.getValue());
                            continue;
                        }
                        options2.getLogger().log(SentryLevel.WARNING, "Invalid key type in gep map.", new Object[0]);
                    }
                    user2.geo = Geo.fromMap(geoData);
                    continue block18;
                }
                case "data": {
                    Map data2 = value2 instanceof Map ? (Map)value2 : null;
                    if (data2 == null) continue block18;
                    ConcurrentHashMap<String, String> userData2 = new ConcurrentHashMap<String, String>();
                    for (Map.Entry dataEntry : data2.entrySet()) {
                        if (dataEntry.getKey() instanceof String && dataEntry.getValue() != null) {
                            userData2.put((String)dataEntry.getKey(), dataEntry.getValue().toString());
                            continue;
                        }
                        options2.getLogger().log(SentryLevel.WARNING, "Invalid key or null value in data map.", new Object[0]);
                    }
                    user2.data = userData2;
                    continue block18;
                }
            }
            if (unknown == null) {
                unknown = new ConcurrentHashMap<String, Object>();
            }
            unknown.put(entry.getKey(), entry.getValue());
        }
        user2.unknown = unknown;
        return user2;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    public void setEmail(@Nullable String email) {
        this.email = email;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id2) {
        this.id = id2;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    public void setUsername(@Nullable String username2) {
        this.username = username2;
    }

    @Nullable
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(@Nullable String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name2) {
        this.name = name2;
    }

    @Nullable
    public Geo getGeo() {
        return this.geo;
    }

    public void setGeo(@Nullable Geo geo) {
        this.geo = geo;
    }

    public @Nullable Map<String, @NotNull String> getData() {
        return this.data;
    }

    public void setData(@Nullable Map<String, @NotNull String> data2) {
        this.data = CollectionUtils.newConcurrentHashMap(data2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user2 = (User)o;
        return Objects.equals(this.email, user2.email) && Objects.equals(this.id, user2.id) && Objects.equals(this.username, user2.username) && Objects.equals(this.ipAddress, user2.ipAddress);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.id, this.username, this.ipAddress);
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        if (this.email != null) {
            writer2.name("email").value(this.email);
        }
        if (this.id != null) {
            writer2.name("id").value(this.id);
        }
        if (this.username != null) {
            writer2.name("username").value(this.username);
        }
        if (this.ipAddress != null) {
            writer2.name("ip_address").value(this.ipAddress);
        }
        if (this.name != null) {
            writer2.name("name").value(this.name);
        }
        if (this.geo != null) {
            writer2.name("geo");
            this.geo.serialize(writer2, logger);
        }
        if (this.data != null) {
            writer2.name("data").value(logger, this.data);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    public static final class JsonKeys {
        public static final String EMAIL = "email";
        public static final String ID = "id";
        public static final String USERNAME = "username";
        public static final String IP_ADDRESS = "ip_address";
        public static final String NAME = "name";
        public static final String GEO = "geo";
        public static final String DATA = "data";
    }

    public static final class Deserializer
    implements JsonDeserializer<User> {
        @Override
        @NotNull
        public User deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            reader2.beginObject();
            User user2 = new User();
            ConcurrentHashMap<String, Object> unknown = null;
            block18: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "email": {
                        user2.email = reader2.nextStringOrNull();
                        continue block18;
                    }
                    case "id": {
                        user2.id = reader2.nextStringOrNull();
                        continue block18;
                    }
                    case "username": {
                        user2.username = reader2.nextStringOrNull();
                        continue block18;
                    }
                    case "ip_address": {
                        user2.ipAddress = reader2.nextStringOrNull();
                        continue block18;
                    }
                    case "name": {
                        user2.name = reader2.nextStringOrNull();
                        continue block18;
                    }
                    case "geo": {
                        user2.geo = new Geo.Deserializer().deserialize(reader2, logger);
                        continue block18;
                    }
                    case "data": {
                        user2.data = CollectionUtils.newConcurrentHashMap((Map)reader2.nextObjectOrNull());
                        continue block18;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            user2.setUnknown(unknown);
            reader2.endObject();
            return user2;
        }
    }
}

