/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.ViewHierarchyNode;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ViewHierarchy
implements JsonUnknown,
JsonSerializable {
    @Nullable
    private final String renderingSystem;
    @Nullable
    private final List<ViewHierarchyNode> windows;
    @Nullable
    private Map<String, Object> unknown;

    public ViewHierarchy(@Nullable String renderingSystem, @Nullable List<ViewHierarchyNode> windows) {
        this.renderingSystem = renderingSystem;
        this.windows = windows;
    }

    @Nullable
    public String getRenderingSystem() {
        return this.renderingSystem;
    }

    @Nullable
    public List<ViewHierarchyNode> getWindows() {
        return this.windows;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        if (this.renderingSystem != null) {
            writer2.name("rendering_system").value(this.renderingSystem);
        }
        if (this.windows != null) {
            writer2.name("windows").value(logger, this.windows);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key).value(logger, value2);
            }
        }
        writer2.endObject();
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class JsonKeys {
        public static final String RENDERING_SYSTEM = "rendering_system";
        public static final String WINDOWS = "windows";
    }

    public static final class Deserializer
    implements JsonDeserializer<ViewHierarchy> {
        @Override
        @NotNull
        public ViewHierarchy deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            @Nullable String renderingSystem = null;
            List<ViewHierarchyNode> windows = null;
            HashMap<String, Object> unknown = null;
            reader2.beginObject();
            block8: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "rendering_system": {
                        renderingSystem = reader2.nextStringOrNull();
                        continue block8;
                    }
                    case "windows": {
                        windows = reader2.nextListOrNull(logger, new ViewHierarchyNode.Deserializer());
                        continue block8;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            reader2.endObject();
            ViewHierarchy viewHierarchy = new ViewHierarchy(renderingSystem, windows);
            viewHierarchy.setUnknown(unknown);
            return viewHierarchy;
        }
    }
}

