/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb.RRWebEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb.RRWebEventType;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class RRWebIncrementalSnapshotEvent
extends RRWebEvent {
    private IncrementalSource source;

    public RRWebIncrementalSnapshotEvent(@NotNull IncrementalSource source2) {
        super(RRWebEventType.IncrementalSnapshot);
        this.source = source2;
    }

    public IncrementalSource getSource() {
        return this.source;
    }

    public void setSource(IncrementalSource source2) {
        this.source = source2;
    }

    public static enum IncrementalSource implements JsonSerializable
    {
        Mutation,
        MouseMove,
        MouseInteraction,
        Scroll,
        ViewportResize,
        Input,
        TouchMove,
        MediaInteraction,
        StyleSheetRule,
        CanvasMutation,
        Font,
        Log,
        Drag,
        StyleDeclaration,
        Selection,
        AdoptedStyleSheet,
        CustomElement;


        @Override
        public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
            writer2.value(this.ordinal());
        }

        public static final class Deserializer
        implements JsonDeserializer<IncrementalSource> {
            @Override
            @NotNull
            public IncrementalSource deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
                return IncrementalSource.values()[reader2.nextInt()];
            }
        }
    }

    public static final class Deserializer {
        public boolean deserializeValue(@NotNull RRWebIncrementalSnapshotEvent baseEvent, @NotNull String nextName, @NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            if (nextName.equals("source")) {
                baseEvent.source = Objects.requireNonNull(reader2.nextOrNull(logger, new IncrementalSource.Deserializer()), "");
                return true;
            }
            return false;
        }
    }

    public static final class Serializer {
        public void serialize(@NotNull RRWebIncrementalSnapshotEvent baseEvent, @NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
            writer2.name("source").value(logger, baseEvent.source);
        }
    }

    public static final class JsonKeys {
        public static final String SOURCE = "source";
    }
}

