/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonUnknown;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectReader;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ObjectWriter;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb.RRWebEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.rrweb.RRWebEventType;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.Objects;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RRWebMetaEvent
extends RRWebEvent
implements JsonUnknown,
JsonSerializable {
    @NotNull
    private String href = "";
    private int height;
    private int width;
    @Nullable
    private Map<String, Object> unknown;
    @Nullable
    private Map<String, Object> dataUnknown;

    public RRWebMetaEvent() {
        super(RRWebEventType.Meta);
    }

    @NotNull
    public String getHref() {
        return this.href;
    }

    public void setHref(@NotNull String href) {
        this.href = href;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Nullable
    public Map<String, Object> getDataUnknown() {
        return this.dataUnknown;
    }

    public void setDataUnknown(@Nullable Map<String, Object> dataUnknown) {
        this.dataUnknown = dataUnknown;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RRWebMetaEvent metaEvent = (RRWebMetaEvent)o;
        return this.height == metaEvent.height && this.width == metaEvent.width && Objects.equals(this.href, metaEvent.href);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.href, this.height, this.width);
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        new RRWebEvent.Serializer().serialize(this, writer2, logger);
        writer2.name("data");
        this.serializeData(writer2, logger);
        writer2.endObject();
    }

    private void serializeData(@NotNull ObjectWriter writer2, @NotNull ILogger logger) throws IOException {
        writer2.beginObject();
        writer2.name("href").value(this.href);
        writer2.name("height").value(this.height);
        writer2.name("width").value(this.width);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer2.name(key);
                writer2.value(logger, value2);
            }
        }
        writer2.endObject();
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class JsonKeys {
        public static final String DATA = "data";
        public static final String HREF = "href";
        public static final String HEIGHT = "height";
        public static final String WIDTH = "width";
    }

    public static final class Deserializer
    implements JsonDeserializer<RRWebMetaEvent> {
        @Override
        @NotNull
        public RRWebMetaEvent deserialize(@NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            reader2.beginObject();
            @Nullable HashMap<String, Object> unknown = null;
            RRWebMetaEvent event2 = new RRWebMetaEvent();
            RRWebEvent.Deserializer baseEventDeserializer = new RRWebEvent.Deserializer();
            block6: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "data": {
                        this.deserializeData(event2, reader2, logger);
                        continue block6;
                    }
                }
                if (baseEventDeserializer.deserializeValue(event2, nextName, reader2, logger)) continue;
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            event2.setUnknown(unknown);
            reader2.endObject();
            return event2;
        }

        private void deserializeData(@NotNull RRWebMetaEvent event2, @NotNull ObjectReader reader2, @NotNull ILogger logger) throws Exception {
            ConcurrentHashMap<String, Object> unknown = null;
            reader2.beginObject();
            block10: while (reader2.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader2.nextName()) {
                    case "href": {
                        String href = reader2.nextStringOrNull();
                        event2.href = href == null ? "" : href;
                        continue block10;
                    }
                    case "height": {
                        Integer height = reader2.nextIntegerOrNull();
                        event2.height = height == null ? 0 : height;
                        continue block10;
                    }
                    case "width": {
                        Integer width = reader2.nextIntegerOrNull();
                        event2.width = width == null ? 0 : width;
                        continue block10;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader2.nextUnknown(logger, unknown, nextName);
            }
            event2.setDataUnknown(unknown);
            reader2.endObject();
        }
    }
}

