/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.FilterString;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryEvent;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.protocol.Message;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ErrorUtils {
    @ApiStatus.Internal
    public static boolean isIgnored(@Nullable List<FilterString> ignoredErrors, @NotNull SentryEvent event2) {
        Throwable throwable;
        if (event2 == null || ignoredErrors == null || ignoredErrors.isEmpty()) {
            return false;
        }
        @NotNull HashSet<String> possibleMessages = new HashSet<String>();
        @Nullable Message eventMessage = event2.getMessage();
        if (eventMessage != null) {
            String formattedMessage;
            @Nullable String stringMessage = eventMessage.getMessage();
            if (stringMessage != null) {
                possibleMessages.add(stringMessage);
            }
            if ((formattedMessage = eventMessage.getFormatted()) != null) {
                possibleMessages.add(formattedMessage);
            }
        }
        if ((throwable = event2.getThrowable()) != null) {
            possibleMessages.add(throwable.toString());
        }
        for (FilterString filter2 : ignoredErrors) {
            if (!possibleMessages.contains(filter2.getFilterString())) continue;
            return true;
        }
        for (FilterString filter2 : ignoredErrors) {
            for (String message2 : possibleMessages) {
                if (!filter2.matches(message2)) continue;
                return true;
            }
        }
        return false;
    }
}

