/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.Hint;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.hints.ApplyScopeData;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.hints.Backfillable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.hints.Cached;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.hints.EventDropReason;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util.LogUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class HintUtils {
    private HintUtils() {
    }

    public static void setIsFromHybridSdk(@NotNull Hint hint, @NotNull String sdkName) {
        if (sdkName.startsWith("sentry.javascript") || sdkName.startsWith("sentry.dart") || sdkName.startsWith("sentry.dotnet")) {
            hint.set("sentry:isFromHybridSdk", true);
        }
    }

    public static boolean isFromHybridSdk(@NotNull Hint hint) {
        return Boolean.TRUE.equals(hint.getAs("sentry:isFromHybridSdk", Boolean.class));
    }

    public static void setEventDropReason(@NotNull Hint hint, @NotNull EventDropReason eventDropReason) {
        hint.set("sentry:eventDropReason", (Object)eventDropReason);
    }

    @Nullable
    public static EventDropReason getEventDropReason(@NotNull Hint hint) {
        return hint.getAs("sentry:eventDropReason", EventDropReason.class);
    }

    public static Hint createWithTypeCheckHint(Object typeCheckHint) {
        Hint hint = new Hint();
        HintUtils.setTypeCheckHint(hint, typeCheckHint);
        return hint;
    }

    public static void setTypeCheckHint(@NotNull Hint hint, Object typeCheckHint) {
        hint.set("sentry:typeCheckHint", typeCheckHint);
    }

    @Nullable
    public static Object getSentrySdkHint(@NotNull Hint hint) {
        return hint.get("sentry:typeCheckHint");
    }

    public static boolean hasType(@NotNull Hint hint, @NotNull Class<?> clazz) {
        Object sentrySdkHint = HintUtils.getSentrySdkHint(hint);
        return clazz.isInstance(sentrySdkHint);
    }

    public static <T> void runIfDoesNotHaveType(@NotNull Hint hint, @NotNull Class<T> clazz, SentryNullableConsumer<Object> lambda2) {
        HintUtils.runIfHasType(hint, clazz, ignored -> {}, (value2, clazz2) -> lambda2.accept(value2));
    }

    public static <T> void runIfHasType(@NotNull Hint hint, @NotNull Class<T> clazz, SentryConsumer<T> lambda2) {
        HintUtils.runIfHasType(hint, clazz, lambda2, (value2, clazz2) -> {});
    }

    public static <T> void runIfHasTypeLogIfNot(@NotNull Hint hint, @NotNull Class<T> clazz, ILogger logger, SentryConsumer<T> lambda2) {
        HintUtils.runIfHasType(hint, clazz, lambda2, (sentrySdkHint, expectedClass) -> LogUtils.logNotInstanceOf(expectedClass, sentrySdkHint, logger));
    }

    public static <T> void runIfHasType(@NotNull Hint hint, @NotNull Class<T> clazz, SentryConsumer<T> lambda2, SentryHintFallback fallbackLambda) {
        Object sentrySdkHint = HintUtils.getSentrySdkHint(hint);
        if (HintUtils.hasType(hint, clazz) && sentrySdkHint != null) {
            lambda2.accept(sentrySdkHint);
        } else {
            fallbackLambda.accept(sentrySdkHint, clazz);
        }
    }

    public static boolean shouldApplyScopeData(@NotNull Hint hint) {
        return !HintUtils.hasType(hint, Cached.class) && !HintUtils.hasType(hint, Backfillable.class) || HintUtils.hasType(hint, ApplyScopeData.class);
    }

    @FunctionalInterface
    public static interface SentryConsumer<T> {
        public void accept(@NotNull T var1);
    }

    @FunctionalInterface
    public static interface SentryNullableConsumer<T> {
        public void accept(@Nullable T var1);
    }

    @FunctionalInterface
    public static interface SentryHintFallback {
        public void accept(@Nullable Object var1, @NotNull Class<?> var2);
    }
}

