/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.io.sentry.util;

import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ILogger;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.ISerializer;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.JsonSerializable;
import io.github.quiltservertools.blockbotdiscord.libs.io.sentry.SentryLevel;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class JsonSerializationUtils {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    @NotNull
    public static Map<String, Object> calendarToMap(@NotNull Calendar calendar) {
        @NotNull HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("year", calendar.get(1));
        map2.put("month", calendar.get(2));
        map2.put("dayOfMonth", calendar.get(5));
        map2.put("hourOfDay", calendar.get(11));
        map2.put("minute", calendar.get(12));
        map2.put("second", calendar.get(13));
        return map2;
    }

    @NotNull
    public static List<Object> atomicIntegerArrayToList(@NotNull AtomicIntegerArray array) {
        int numberOfItems = array.length();
        @NotNull ArrayList<Object> list2 = new ArrayList<Object>(numberOfItems);
        for (int i = 0; i < numberOfItems; ++i) {
            list2.add(array.get(i));
        }
        return list2;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static byte[] bytesFrom(@NotNull ISerializer serializer2, @NotNull ILogger logger, @NotNull JsonSerializable serializable) {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, UTF_8));){
                serializer2.serialize(serializable, writer2);
                byArray = stream.toByteArray();
            }
            return byArray;
        }
        catch (Throwable t) {
            logger.log(SentryLevel.ERROR, "Could not serialize serializable", t);
            return null;
        }
    }
}

