/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode;

import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.AttributeInfo;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.ByteArray;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.ConstPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;

public class MethodParametersAttribute
extends AttributeInfo {
    public static final String tag = "MethodParameters";

    MethodParametersAttribute(ConstPool cp, int n, DataInputStream in) throws IOException {
        super(cp, n, in);
    }

    public MethodParametersAttribute(ConstPool cp, String[] names, int[] flags2) {
        super(cp, tag);
        byte[] data2 = new byte[names.length * 4 + 1];
        data2[0] = (byte)names.length;
        for (int i = 0; i < names.length; ++i) {
            ByteArray.write16bit(cp.addUtf8Info(names[i]), data2, i * 4 + 1);
            ByteArray.write16bit(flags2[i], data2, i * 4 + 3);
        }
        this.set(data2);
    }

    public int size() {
        return this.info[0] & 0xFF;
    }

    public int name(int i) {
        return ByteArray.readU16bit(this.info, i * 4 + 1);
    }

    public int accessFlags(int i) {
        return ByteArray.readU16bit(this.info, i * 4 + 3);
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        int s = this.size();
        ConstPool cp = this.getConstPool();
        String[] names = new String[s];
        int[] flags2 = new int[s];
        for (int i = 0; i < s; ++i) {
            names[i] = cp.getUtf8Info(this.name(i));
            flags2[i] = this.accessFlags(i);
        }
        return new MethodParametersAttribute(newCp, names, flags2);
    }
}

