/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation;

import io.github.quiltservertools.blockbotdiscord.libs.javassist.ClassPool;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.CtClass;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.CtMethod;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.NotFoundException;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.ConstPool;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.Descriptor;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.AnnotationImpl;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.AnnotationMemberValue;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.AnnotationsWriter;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.ArrayMemberValue;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.BooleanMemberValue;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.ByteMemberValue;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.CharMemberValue;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.ClassMemberValue;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.DoubleMemberValue;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.EnumMemberValue;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.FloatMemberValue;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.IntegerMemberValue;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.LongMemberValue;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.MemberValue;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.NoSuchClassError;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.ShortMemberValue;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.annotation.StringMemberValue;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Annotation {
    ConstPool pool;
    int typeIndex;
    Map<String, Pair> members;

    public Annotation(int type, ConstPool cp) {
        this.pool = cp;
        this.typeIndex = type;
        this.members = null;
    }

    public Annotation(String typeName, ConstPool cp) {
        this(cp.addUtf8Info(Descriptor.of(typeName)), cp);
    }

    public Annotation(ConstPool cp, CtClass clazz) throws NotFoundException {
        this(cp.addUtf8Info(Descriptor.of(clazz.getName())), cp);
        if (!clazz.isInterface()) {
            throw new RuntimeException("Only interfaces are allowed for Annotation creation.");
        }
        CtMethod[] methods = clazz.getDeclaredMethods();
        if (methods.length > 0) {
            this.members = new LinkedHashMap<String, Pair>();
        }
        for (CtMethod m : methods) {
            this.addMemberValue(m.getName(), Annotation.createMemberValue(cp, m.getReturnType()));
        }
    }

    public static MemberValue createMemberValue(ConstPool cp, CtClass type) throws NotFoundException {
        if (type == CtClass.booleanType) {
            return new BooleanMemberValue(cp);
        }
        if (type == CtClass.byteType) {
            return new ByteMemberValue(cp);
        }
        if (type == CtClass.charType) {
            return new CharMemberValue(cp);
        }
        if (type == CtClass.shortType) {
            return new ShortMemberValue(cp);
        }
        if (type == CtClass.intType) {
            return new IntegerMemberValue(cp);
        }
        if (type == CtClass.longType) {
            return new LongMemberValue(cp);
        }
        if (type == CtClass.floatType) {
            return new FloatMemberValue(cp);
        }
        if (type == CtClass.doubleType) {
            return new DoubleMemberValue(cp);
        }
        if (type.getName().equals("java.lang.Class")) {
            return new ClassMemberValue(cp);
        }
        if (type.getName().equals("java.lang.String")) {
            return new StringMemberValue(cp);
        }
        if (type.isArray()) {
            CtClass arrayType = type.getComponentType();
            MemberValue member2 = Annotation.createMemberValue(cp, arrayType);
            return new ArrayMemberValue(member2, cp);
        }
        if (type.isInterface()) {
            Annotation info2 = new Annotation(cp, type);
            return new AnnotationMemberValue(info2, cp);
        }
        EnumMemberValue emv = new EnumMemberValue(cp);
        emv.setType(type.getName());
        return emv;
    }

    public void addMemberValue(int nameIndex, MemberValue value2) {
        Pair p = new Pair();
        p.name = nameIndex;
        p.value = value2;
        this.addMemberValue(p);
    }

    public void addMemberValue(String name2, MemberValue value2) {
        Pair p = new Pair();
        p.name = this.pool.addUtf8Info(name2);
        p.value = value2;
        if (this.members == null) {
            this.members = new LinkedHashMap<String, Pair>();
        }
        this.members.put(name2, p);
    }

    private void addMemberValue(Pair pair) {
        String name2 = this.pool.getUtf8Info(pair.name);
        if (this.members == null) {
            this.members = new LinkedHashMap<String, Pair>();
        }
        this.members.put(name2, pair);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("@");
        buf.append(this.getTypeName());
        if (this.members != null) {
            buf.append("(");
            for (String name2 : this.members.keySet()) {
                buf.append(name2).append("=").append(this.getMemberValue(name2)).append(", ");
            }
            buf.setLength(buf.length() - 2);
            buf.append(")");
        }
        return buf.toString();
    }

    public String getTypeName() {
        return Descriptor.toClassName(this.pool.getUtf8Info(this.typeIndex));
    }

    public Set<String> getMemberNames() {
        if (this.members == null) {
            return null;
        }
        return this.members.keySet();
    }

    public MemberValue getMemberValue(String name2) {
        if (this.members == null || this.members.get(name2) == null) {
            return null;
        }
        return this.members.get((Object)name2).value;
    }

    public Object toAnnotationType(ClassLoader cl, ClassPool cp) throws ClassNotFoundException, NoSuchClassError {
        Class<?> clazz = MemberValue.loadClass(cl, this.getTypeName());
        try {
            return AnnotationImpl.make(cl, clazz, cp, this);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(clazz.getName(), e);
        }
        catch (IllegalAccessError e2) {
            throw new ClassNotFoundException(clazz.getName(), e2);
        }
    }

    public void write(AnnotationsWriter writer2) throws IOException {
        String typeName = this.pool.getUtf8Info(this.typeIndex);
        if (this.members == null) {
            writer2.annotation(typeName, 0);
            return;
        }
        writer2.annotation(typeName, this.members.size());
        for (Pair pair : this.members.values()) {
            writer2.memberValuePair(pair.name);
            pair.value.write(writer2);
        }
    }

    public int hashCode() {
        return this.getTypeName().hashCode() + (this.members == null ? 0 : this.members.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Annotation)) {
            return false;
        }
        Annotation other = (Annotation)obj;
        if (!this.getTypeName().equals(other.getTypeName())) {
            return false;
        }
        Map<String, Pair> otherMembers = other.members;
        if (this.members == otherMembers) {
            return true;
        }
        if (this.members == null) {
            return otherMembers == null;
        }
        if (otherMembers == null) {
            return false;
        }
        return this.members.equals(otherMembers);
    }

    static class Pair {
        int name;
        MemberValue value;

        Pair() {
        }
    }
}

