/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.javassist.compiler.ast;

import io.github.quiltservertools.blockbotdiscord.libs.javassist.compiler.CompileError;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.compiler.ast.ASTree;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.compiler.ast.Visitor;

public class ASTList
extends ASTree {
    private static final long serialVersionUID = 1L;
    private ASTree left;
    private ASTList right;

    public ASTList(ASTree _head, ASTList _tail) {
        this.left = _head;
        this.right = _tail;
    }

    public ASTList(ASTree _head) {
        this.left = _head;
        this.right = null;
    }

    public static ASTList make(ASTree e1, ASTree e2, ASTree e3) {
        return new ASTList(e1, new ASTList(e2, new ASTList(e3)));
    }

    @Override
    public ASTree getLeft() {
        return this.left;
    }

    @Override
    public ASTree getRight() {
        return this.right;
    }

    @Override
    public void setLeft(ASTree _left) {
        this.left = _left;
    }

    @Override
    public void setRight(ASTree _right) {
        this.right = (ASTList)_right;
    }

    public ASTree head() {
        return this.left;
    }

    public void setHead(ASTree _head) {
        this.left = _head;
    }

    public ASTList tail() {
        return this.right;
    }

    public void setTail(ASTList _tail) {
        this.right = _tail;
    }

    @Override
    public void accept(Visitor v) throws CompileError {
        v.atASTList(this);
    }

    @Override
    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("(<");
        sbuf.append(this.getTag());
        sbuf.append('>');
        ASTList list2 = this;
        while (list2 != null) {
            sbuf.append(' ');
            ASTree a = list2.left;
            sbuf.append(a == null ? "<null>" : a.toString());
            list2 = list2.right;
        }
        sbuf.append(')');
        return sbuf.toString();
    }

    public int length() {
        return ASTList.length(this);
    }

    public static int length(ASTList list2) {
        if (list2 == null) {
            return 0;
        }
        int n = 0;
        while (list2 != null) {
            list2 = list2.right;
            ++n;
        }
        return n;
    }

    public ASTList sublist(int nth) {
        ASTList list2 = this;
        while (nth-- > 0) {
            list2 = list2.right;
        }
        return list2;
    }

    public boolean subst(ASTree newObj, ASTree oldObj) {
        ASTList list2 = this;
        while (list2 != null) {
            if (list2.left == oldObj) {
                list2.left = newObj;
                return true;
            }
            list2 = list2.right;
        }
        return false;
    }

    public static ASTList append(ASTList a, ASTree b) {
        return ASTList.concat(a, new ASTList(b));
    }

    public static ASTList concat(ASTList a, ASTList b) {
        if (a == null) {
            return b;
        }
        ASTList list2 = a;
        while (list2.right != null) {
            list2 = list2.right;
        }
        list2.right = b;
        return a;
    }
}

