/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.javassist.convert;

import io.github.quiltservertools.blockbotdiscord.libs.javassist.CtClass;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.CtField;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.Modifier;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.CodeAttribute;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.CodeIterator;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.bytecode.ConstPool;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.convert.TransformReadField;
import io.github.quiltservertools.blockbotdiscord.libs.javassist.convert.Transformer;

public final class TransformFieldAccess
extends Transformer {
    private String newClassname;
    private String newFieldname;
    private String fieldname;
    private CtClass fieldClass;
    private boolean isPrivate;
    private int newIndex;
    private ConstPool constPool;

    public TransformFieldAccess(Transformer next, CtField field2, String newClassname, String newFieldname) {
        super(next);
        this.fieldClass = field2.getDeclaringClass();
        this.fieldname = field2.getName();
        this.isPrivate = Modifier.isPrivate(field2.getModifiers());
        this.newClassname = newClassname;
        this.newFieldname = newFieldname;
        this.constPool = null;
    }

    @Override
    public void initialize(ConstPool cp, CodeAttribute attr) {
        if (this.constPool != cp) {
            this.newIndex = 0;
        }
    }

    @Override
    public int transform(CtClass clazz, int pos, CodeIterator iterator2, ConstPool cp) {
        int c = iterator2.byteAt(pos);
        if (c == 180 || c == 178 || c == 181 || c == 179) {
            int index = iterator2.u16bitAt(pos + 1);
            String typedesc = TransformReadField.isField(clazz.getClassPool(), cp, this.fieldClass, this.fieldname, this.isPrivate, index);
            if (typedesc != null) {
                if (this.newIndex == 0) {
                    int nt = cp.addNameAndTypeInfo(this.newFieldname, typedesc);
                    this.newIndex = cp.addFieldrefInfo(cp.addClassInfo(this.newClassname), nt);
                    this.constPool = cp;
                }
                iterator2.write16bit(this.newIndex, pos + 1);
            }
        }
        return pos;
    }
}

