/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime;

import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.ConvertersKt;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.DatePeriod;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.DateTimeArithmeticException;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.DateTimeUnit;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.LocalDate;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.internal.MathJvmKt;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.internal.MathKt;
import java.time.DateTimeException;
import java.time.Month;
import java.time.temporal.ChronoUnit;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.PublishedApi;
import kotlin.ReplaceWith;
import kotlin.internal.LowPriorityInOverloadResolution;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u001a'\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u001b\u0010\n\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u000b\u001a#\u0010\n\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bH\u0001\u00a2\u0006\u0004\b\n\u0010\r\u001a#\u0010\u000e\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bH\u0001\u00a2\u0006\u0004\b\u000e\u0010\r\u001a!\u0010\n\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u0010\u001a\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a\u001c\u0010\n\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0015H\u0086\u0002\u00a2\u0006\u0004\b\n\u0010\u0017\u001a\u0019\u0010\u0019\u001a\u00020\u0015*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a!\u0010\u001b\u001a\u00020\u000f*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a#\u0010\u001e\u001a\u00020\u0000*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bH\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001d\u001a\u0019\u0010\u001f\u001a\u00020\u0000*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001f\u0010 \u001a\u0019\u0010!\u001a\u00020\u0000*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\u0004\b!\u0010 \u001a\u0019\u0010\"\u001a\u00020\u0000*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\u0004\b\"\u0010 \"\u0014\u0010#\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$\"\u0014\u0010%\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010$\u00a8\u0006&"}, d2={"", "year", "Ljava/time/Month;", "month", "dayOfMonth", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;", "LocalDate", "(ILjava/time/Month;I)Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit$DateBased;", "unit", "plus", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit$DateBased;)Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;", "value", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;ILio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit$DateBased;)Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;", "minus", "", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;JLio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit$DateBased;)Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;", "epochDay", "Ljava/time/LocalDate;", "ofEpochDayChecked", "(J)Ljava/time/LocalDate;", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DatePeriod;", "period", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DatePeriod;)Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;", "other", "periodUntil", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;)Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DatePeriod;", "until", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit$DateBased;)J", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit$DateBased;)I", "untilJvm", "daysUntil", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;)I", "monthsUntil", "yearsUntil", "minEpochDay", "J", "maxEpochDay", "kotlinx-datetime"})
@JvmName(name="LocalDateJvmKt")
@SourceDebugExtension(value={"SMAP\nLocalDate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDate.kt\nkotlinx/datetime/LocalDateJvmKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
public final class LocalDateJvmKt {
    private static final long minEpochDay = java.time.LocalDate.MIN.toEpochDay();
    private static final long maxEpochDay = java.time.LocalDate.MAX.toEpochDay();

    @Deprecated(message="Use the constructor that accepts a 'day'", replaceWith=@ReplaceWith(expression="LocalDate(year = year, month = month.toKotlinMonth(), day = dayOfMonth)", imports={}), level=DeprecationLevel.WARNING)
    @LowPriorityInOverloadResolution
    @NotNull
    public static final LocalDate LocalDate(int year2, @NotNull Month month2, int dayOfMonth2) {
        Intrinsics.checkNotNullParameter((Object)month2, (String)"month");
        return new LocalDate(year2, ConvertersKt.toKotlinMonth(month2), dayOfMonth2);
    }

    @Deprecated(message="Use the plus overload with an explicit number of units", replaceWith=@ReplaceWith(expression="this.plus(1, unit)", imports={}))
    @NotNull
    public static final LocalDate plus(@NotNull LocalDate $this$plus, @NotNull DateTimeUnit.DateBased unit) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return LocalDateJvmKt.plus($this$plus, 1L, unit);
    }

    @PublishedApi
    @LowPriorityInOverloadResolution
    @NotNull
    public static final LocalDate plus(@NotNull LocalDate $this$plus, int value2, @NotNull DateTimeUnit.DateBased unit) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return LocalDateJvmKt.plus($this$plus, (long)value2, unit);
    }

    @PublishedApi
    @LowPriorityInOverloadResolution
    @NotNull
    public static final LocalDate minus(@NotNull LocalDate $this$minus, int value2, @NotNull DateTimeUnit.DateBased unit) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return LocalDateJvmKt.plus($this$minus, -((long)value2), unit);
    }

    @NotNull
    public static final LocalDate plus(@NotNull LocalDate $this$plus, long value2, @NotNull DateTimeUnit.DateBased unit) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        try {
            java.time.LocalDate localDate;
            object = unit;
            if (object instanceof DateTimeUnit.DayBased) {
                long addDays = MathJvmKt.safeMultiply(value2, (long)((DateTimeUnit.DayBased)unit).getDays());
                localDate = LocalDateJvmKt.ofEpochDayChecked(MathJvmKt.safeAdd($this$plus.getValue$kotlinx_datetime().toEpochDay(), addDays));
            } else if (object instanceof DateTimeUnit.MonthBased) {
                localDate = $this$plus.getValue$kotlinx_datetime().plusMonths(MathJvmKt.safeMultiply(value2, (long)((DateTimeUnit.MonthBased)unit).getMonths()));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            java.time.LocalDate p0 = localDate;
            boolean bl = false;
            object = new LocalDate(p0);
        }
        catch (Exception e) {
            if (!(e instanceof DateTimeException) && !(e instanceof ArithmeticException)) {
                throw e;
            }
            throw new DateTimeArithmeticException("The result of adding " + value2 + " of " + unit + " to " + $this$plus + " is out of LocalDate range.", e);
        }
        return object;
    }

    private static final java.time.LocalDate ofEpochDayChecked(long epochDay) {
        long l = minEpochDay;
        if (!(epochDay <= maxEpochDay ? l <= epochDay : false)) {
            throw new DateTimeException("The resulting day " + epochDay + " is out of supported LocalDate range.");
        }
        java.time.LocalDate localDate = java.time.LocalDate.ofEpochDay(epochDay);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"ofEpochDay(...)");
        return localDate;
    }

    @NotNull
    public static final LocalDate plus(@NotNull LocalDate $this$plus, @NotNull DatePeriod period) {
        LocalDate localDate;
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        try {
            DatePeriod $this$plus_u24lambda_u242 = period;
            boolean bl = false;
            java.time.LocalDate $this$plus_u24lambda_u242_u24lambda_u240 = $this$plus.getValue$kotlinx_datetime();
            boolean bl2 = false;
            java.time.LocalDate $this$plus_u24lambda_u242_u24lambda_u241 = $this$plus_u24lambda_u242.getTotalMonths$kotlinx_datetime() != 0L ? $this$plus_u24lambda_u242_u24lambda_u240.plusMonths($this$plus_u24lambda_u242.getTotalMonths$kotlinx_datetime()) : $this$plus_u24lambda_u242_u24lambda_u240;
            boolean bl3 = false;
            java.time.LocalDate p0 = $this$plus_u24lambda_u242.getDays() != 0 ? $this$plus_u24lambda_u242_u24lambda_u241.plusDays($this$plus_u24lambda_u242.getDays()) : $this$plus_u24lambda_u242_u24lambda_u241;
            boolean bl4 = false;
            localDate = new LocalDate(p0);
        }
        catch (DateTimeException e) {
            throw new DateTimeArithmeticException("The result of adding " + $this$plus.getValue$kotlinx_datetime() + " to " + $this$plus + " is out of LocalDate range.");
        }
        return localDate;
    }

    @NotNull
    public static final DatePeriod periodUntil(@NotNull LocalDate $this$periodUntil, @NotNull LocalDate other) {
        Intrinsics.checkNotNullParameter((Object)$this$periodUntil, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        java.time.LocalDate startD = $this$periodUntil.getValue$kotlinx_datetime();
        java.time.LocalDate endD = other.getValue$kotlinx_datetime();
        long months = startD.until(endD, ChronoUnit.MONTHS);
        java.time.LocalDate localDate = startD.plusMonths(months);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"plusMonths(...)");
        startD = localDate;
        long days = startD.until(endD, ChronoUnit.DAYS);
        return new DatePeriod(months, (int)days);
    }

    public static final long until(@NotNull LocalDate $this$until, @NotNull LocalDate other, @NotNull DateTimeUnit.DateBased unit) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$until, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        DateTimeUnit.DateBased dateBased = unit;
        if (dateBased instanceof DateTimeUnit.MonthBased) {
            l = $this$until.getValue$kotlinx_datetime().until(other.getValue$kotlinx_datetime(), ChronoUnit.MONTHS) / (long)((DateTimeUnit.MonthBased)unit).getMonths();
        } else if (dateBased instanceof DateTimeUnit.DayBased) {
            l = $this$until.getValue$kotlinx_datetime().until(other.getValue$kotlinx_datetime(), ChronoUnit.DAYS) / (long)((DateTimeUnit.DayBased)unit).getDays();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return l;
    }

    @PublishedApi
    @JvmName(name="until")
    public static final int until(@NotNull LocalDate $this$untilJvm, @NotNull LocalDate other, @NotNull DateTimeUnit.DateBased unit) {
        Intrinsics.checkNotNullParameter((Object)$this$untilJvm, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return MathKt.clampToInt(LocalDateJvmKt.until($this$untilJvm, other, unit));
    }

    public static final int daysUntil(@NotNull LocalDate $this$daysUntil, @NotNull LocalDate other) {
        Intrinsics.checkNotNullParameter((Object)$this$daysUntil, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return MathKt.clampToInt($this$daysUntil.getValue$kotlinx_datetime().until(other.getValue$kotlinx_datetime(), ChronoUnit.DAYS));
    }

    public static final int monthsUntil(@NotNull LocalDate $this$monthsUntil, @NotNull LocalDate other) {
        Intrinsics.checkNotNullParameter((Object)$this$monthsUntil, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return MathKt.clampToInt($this$monthsUntil.getValue$kotlinx_datetime().until(other.getValue$kotlinx_datetime(), ChronoUnit.MONTHS));
    }

    public static final int yearsUntil(@NotNull LocalDate $this$yearsUntil, @NotNull LocalDate other) {
        Intrinsics.checkNotNullParameter((Object)$this$yearsUntil, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (int)$this$yearsUntil.getValue$kotlinx_datetime().until(other.getValue$kotlinx_datetime(), ChronoUnit.YEARS);
    }
}

