/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime;

import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.DateTimeArithmeticException;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.DateTimeUnit;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.LocalDate;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.YearMonth;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.format.DateTimeFormat;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.internal.MathJvmKt;
import io.github.quiltservertools.blockbotdiscord.libs.kotlinx.datetime.internal.MathKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000e\u001a\u001f\u0010\u0002\u001a\u00020\u0003*\u00020\u00002\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0001\u00a2\u0006\u0004\b\u0002\u0010\u0004\u001a\u0019\u0010\b\u001a\u00020\u0007*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0019\u0010\u000b\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0019\u0010\r\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000\u00a2\u0006\u0004\b\r\u0010\f\u001a!\u0010\u0011\u001a\u00020\u0010*\u00020\u00002\u0006\u0010\n\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u0011\u0010\u0013\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a\u0011\u0010\u0015\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0014\u001a\u0011\u0010\u0016\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0014\u001a\u0011\u0010\u0017\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0014\u001a!\u0010\u0019\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a!\u0010\u001b\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001b\u0010\u001a\u001a!\u0010\u0019\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0019\u0010\u001c\u001a!\u0010\u001b\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u001b\u0010\u001f\u001a\u00020\u0000*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0010H\u0000\u00a2\u0006\u0004\b\u001f\u0010 \"\u0015\u0010#\u001a\u00020\u0000*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\"\u0018\u0010\u001e\u001a\u00020\u0010*\u00020\u00008@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\"\u0018\u0010(\u001a\u00020\u0000*\u00020\u001d8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\"\u0018\u0010*\u001a\u00020\u0000*\u00020\u001d8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010'\u00a8\u0006+"}, d2={"Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/format/DateTimeFormat;", "format", "", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/format/DateTimeFormat;)Ljava/lang/String;", "", "day", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;", "onDay", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;I)Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/LocalDate;", "other", "yearsUntil", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;)I", "monthsUntil", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit$MonthBased;", "unit", "", "until", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit$MonthBased;)J", "plusYear", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;)Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;", "minusYear", "plusMonth", "minusMonth", "value", "plus", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;ILio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit$MonthBased;)Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;", "minus", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;JLio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/DateTimeUnit$MonthBased;)Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;", "Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth$Companion;", "prolepticMonth", "fromProlepticMonth", "(Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth$Companion;J)Lio/github/quiltservertools/blockbotdiscord/libs/kotlinx/datetime/YearMonth;", "getYearMonth", "(Lkotlinx/datetime/LocalDate;)Lkotlinx/datetime/YearMonth;", "yearMonth", "getProlepticMonth", "(Lkotlinx/datetime/YearMonth;)J", "getMAX", "(Lkotlinx/datetime/YearMonth$Companion;)Lkotlinx/datetime/YearMonth;", "MAX", "getMIN", "MIN", "kotlinx-datetime"})
public final class YearMonthKt {
    @NotNull
    public static final String format(@NotNull YearMonth $this$format, @NotNull DateTimeFormat<YearMonth> format) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        Intrinsics.checkNotNullParameter(format, (String)"format");
        return format.format($this$format);
    }

    @NotNull
    public static final YearMonth getYearMonth(@NotNull LocalDate $this$yearMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$yearMonth, (String)"<this>");
        return new YearMonth($this$yearMonth.getYear(), $this$yearMonth.getMonth());
    }

    @NotNull
    public static final LocalDate onDay(@NotNull YearMonth $this$onDay, int day2) {
        Intrinsics.checkNotNullParameter((Object)$this$onDay, (String)"<this>");
        return new LocalDate($this$onDay.getYear(), $this$onDay.getMonth(), day2);
    }

    public static final int yearsUntil(@NotNull YearMonth $this$yearsUntil, @NotNull YearMonth other) {
        Intrinsics.checkNotNullParameter((Object)$this$yearsUntil, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (int)((YearMonthKt.getProlepticMonth(other) - YearMonthKt.getProlepticMonth($this$yearsUntil)) / 12L);
    }

    public static final int monthsUntil(@NotNull YearMonth $this$monthsUntil, @NotNull YearMonth other) {
        Intrinsics.checkNotNullParameter((Object)$this$monthsUntil, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return MathKt.clampToInt(YearMonthKt.getProlepticMonth(other) - YearMonthKt.getProlepticMonth($this$monthsUntil));
    }

    public static final long until(@NotNull YearMonth $this$until, @NotNull YearMonth other, @NotNull DateTimeUnit.MonthBased unit) {
        Intrinsics.checkNotNullParameter((Object)$this$until, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return (YearMonthKt.getProlepticMonth(other) - YearMonthKt.getProlepticMonth($this$until)) / (long)unit.getMonths();
    }

    @NotNull
    public static final YearMonth plusYear(@NotNull YearMonth $this$plusYear) {
        Intrinsics.checkNotNullParameter((Object)$this$plusYear, (String)"<this>");
        return YearMonthKt.plus($this$plusYear, 1, DateTimeUnit.Companion.getYEAR());
    }

    @NotNull
    public static final YearMonth minusYear(@NotNull YearMonth $this$minusYear) {
        Intrinsics.checkNotNullParameter((Object)$this$minusYear, (String)"<this>");
        return YearMonthKt.minus($this$minusYear, 1, DateTimeUnit.Companion.getYEAR());
    }

    @NotNull
    public static final YearMonth plusMonth(@NotNull YearMonth $this$plusMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$plusMonth, (String)"<this>");
        return YearMonthKt.plus($this$plusMonth, 1, DateTimeUnit.Companion.getMONTH());
    }

    @NotNull
    public static final YearMonth minusMonth(@NotNull YearMonth $this$minusMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$minusMonth, (String)"<this>");
        return YearMonthKt.minus($this$minusMonth, 1, DateTimeUnit.Companion.getMONTH());
    }

    @NotNull
    public static final YearMonth plus(@NotNull YearMonth $this$plus, int value2, @NotNull DateTimeUnit.MonthBased unit) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return YearMonthKt.plus($this$plus, (long)value2, unit);
    }

    @NotNull
    public static final YearMonth minus(@NotNull YearMonth $this$minus, int value2, @NotNull DateTimeUnit.MonthBased unit) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return YearMonthKt.minus($this$minus, (long)value2, unit);
    }

    @NotNull
    public static final YearMonth plus(@NotNull YearMonth $this$plus, long value2, @NotNull DateTimeUnit.MonthBased unit) {
        YearMonth yearMonth;
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        try {
            long monthsToAdd = MathJvmKt.safeMultiply(value2, (long)unit.getMonths());
            boolean bl = false;
            yearMonth = monthsToAdd == 0L ? $this$plus : YearMonthKt.fromProlepticMonth(YearMonth.Companion, MathJvmKt.safeAdd(YearMonthKt.getProlepticMonth($this$plus), monthsToAdd));
        }
        catch (ArithmeticException e) {
            throw new DateTimeArithmeticException("Arithmetic overflow when adding " + value2 + " of " + unit + " to " + $this$plus, e);
        }
        catch (IllegalArgumentException e) {
            throw new DateTimeArithmeticException("Boundaries of YearMonth exceeded when adding " + value2 + " of " + unit + " to " + $this$plus, e);
        }
        return yearMonth;
    }

    @NotNull
    public static final YearMonth minus(@NotNull YearMonth $this$minus, long value2, @NotNull DateTimeUnit.MonthBased unit) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return value2 != Long.MIN_VALUE ? YearMonthKt.plus($this$minus, -value2, unit) : YearMonthKt.plus(YearMonthKt.plus($this$minus, Long.MAX_VALUE, unit), 1, unit);
    }

    public static final long getProlepticMonth(@NotNull YearMonth $this$prolepticMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$prolepticMonth, (String)"<this>");
        return (long)$this$prolepticMonth.getYear() * 12L + (long)($this$prolepticMonth.getMonthNumber$kotlinx_datetime() - 1);
    }

    @NotNull
    public static final YearMonth fromProlepticMonth(@NotNull YearMonth.Companion $this$fromProlepticMonth, long prolepticMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$fromProlepticMonth, (String)"<this>");
        long l = prolepticMonth;
        long l2 = 12;
        long l3 = l / l2;
        if ((l ^ l2) < 0L && l3 * l2 != l) {
            l3 += -1L;
        }
        long year2 = l3;
        int n = LocalDate.Companion.getMIN$kotlinx_datetime().getYear();
        if (!(year2 <= (long)LocalDate.Companion.getMAX$kotlinx_datetime().getYear() ? (long)n <= year2 : false)) {
            boolean bl = false;
            String string = "Year " + year2 + " is out of range: " + LocalDate.Companion.getMIN$kotlinx_datetime().getYear() + ".." + LocalDate.Companion.getMAX$kotlinx_datetime().getYear();
            throw new IllegalArgumentException(string.toString());
        }
        long l4 = prolepticMonth;
        long l5 = 12;
        long l6 = l4 % l5;
        int month2 = (int)(l6 + (l5 & ((l6 ^ l5) & (l6 | -l6)) >> 63)) + 1;
        return new YearMonth((int)year2, month2);
    }

    @NotNull
    public static final YearMonth getMAX(@NotNull YearMonth.Companion $this$MAX) {
        Intrinsics.checkNotNullParameter((Object)$this$MAX, (String)"<this>");
        return YearMonthKt.getYearMonth(LocalDate.Companion.getMAX$kotlinx_datetime());
    }

    @NotNull
    public static final YearMonth getMIN(@NotNull YearMonth.Companion $this$MIN) {
        Intrinsics.checkNotNullParameter((Object)$this$MIN, (String)"<this>");
        return YearMonthKt.getYearMonth(LocalDate.Companion.getMIN$kotlinx_datetime());
    }
}

